/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha.backgrounds;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jj.play.ns.nl.captcha.backgrounds.BackgroundProducer;

public class GradiatedBackgroundProducer
implements BackgroundProducer {
    private Color _fromColor = Color.DARK_GRAY;
    private Color _toColor = Color.WHITE;

    public BufferedImage getBackground(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(renderingHints);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this._fromColor, n, n2, this._toColor);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage addBackground(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        return this.getBackground(n, n2);
    }

    public void setFromColor(Color color) {
        this._fromColor = color;
    }

    public void setToColor(Color color) {
        this._toColor = color;
    }
}

