/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExceptionHandler;

public class ExceptionHandlers {
    private HashMap<InstructionHandle, Set<ExceptionHandler>> exceptionhandlers = new HashMap();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs;
        for (CodeExceptionGen ceg : cegs = mg.getExceptionHandlers()) {
            ExceptionHandler eh = new ExceptionHandler(ceg.getCatchType(), ceg.getHandlerPC());
            for (InstructionHandle ih = ceg.getStartPC(); ih != ceg.getEndPC().getNext(); ih = ih.getNext()) {
                Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return hs.toArray(ret);
    }
}

