/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public class ModelInspector {
    private IJavaProject javaProject;

    public ModelInspector(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IMethod resolveAction(String input) {
        if (input.indexOf(46) == -1) {
            return null;
        }
        String typeName = input.substring(0, input.lastIndexOf(46));
        String query = input.substring(input.lastIndexOf(46) + 1);
        return this.getAction("controllers." + typeName, query);
    }

    private IMethod getAction(String fullClassName, String query) {
        IType parent = null;
        try {
            parent = this.javaProject.findType(fullClassName);
        }
        catch (JavaModelException javaModelException) {}
        if (parent == null) {
            return null;
        }
        try {
            IMethod method = this.findMethod(parent, query);
            if (method != null) {
                return method;
            }
            ITypeHierarchy hierarchy = parent.newTypeHierarchy(null);
            IType[] iTypeArray = hierarchy.getAllSuperclasses(parent);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType superclass = iTypeArray[n2];
                method = this.findMethod(superclass, query);
                if (method != null) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private IMethod findMethod(IType type, String query) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            int flags = method.getFlags();
            if (Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && method.getReturnType().equals("V") && method.getElementName().equals(query)) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

