/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Digits;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigitsCheck
extends AbstractAnnotationCheck<Digits> {
    private static final long serialVersionUID = 1L;
    private int maxFraction = Integer.MAX_VALUE;
    private int maxInteger = Integer.MAX_VALUE;
    private int minFraction = 0;
    private int minInteger = 0;

    @Override
    public void configure(Digits constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMinInteger(constraintAnnotation.minInteger());
        this.setMaxInteger(constraintAnnotation.maxInteger());
        this.setMinFraction(constraintAnnotation.minFraction());
        this.setMaxFraction(constraintAnnotation.maxFraction());
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("maxInteger", Integer.toString(this.maxInteger));
        messageVariables.put("minInteger", Integer.toString(this.minInteger));
        messageVariables.put("maxFraction", Integer.toString(this.maxFraction));
        messageVariables.put("minFraction", Integer.toString(this.minFraction));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public int getMaxFraction() {
        return this.maxFraction;
    }

    public int getMaxInteger() {
        return this.maxInteger;
    }

    public int getMinFraction() {
        return this.minFraction;
    }

    public int getMinInteger() {
        return this.minInteger;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        int fractionLen;
        if (valueToValidate == null) {
            return true;
        }
        BigDecimal value = valueToValidate instanceof BigDecimal ? (BigDecimal)valueToValidate : (valueToValidate instanceof BigInteger ? new BigDecimal((BigInteger)valueToValidate) : (valueToValidate instanceof Integer ? new BigDecimal((Integer)valueToValidate) : (valueToValidate instanceof Long ? new BigDecimal((Long)valueToValidate) : (valueToValidate instanceof Short ? new BigDecimal(((Short)valueToValidate).shortValue()) : (valueToValidate instanceof Byte ? new BigDecimal(((Byte)valueToValidate).byteValue()) : new BigDecimal(valueToValidate.toString()))))));
        int valueScale = value.scale();
        int integerLen = value.precision() - valueScale;
        int n = fractionLen = valueScale > 0 ? valueScale : 0;
        return integerLen <= this.maxInteger && integerLen >= this.minInteger && fractionLen <= this.maxFraction && fractionLen >= this.minFraction;
    }

    public void setMaxFraction(int maxFraction) {
        this.maxFraction = maxFraction;
    }

    public void setMaxInteger(int maxInteger) {
        this.maxInteger = maxInteger;
    }

    public void setMinFraction(int minFraction) {
        this.minFraction = minFraction;
    }

    public void setMinInteger(int minInteger) {
        this.minInteger = minInteger;
    }
}

