/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.CheckWith;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckWithCheck
extends AbstractAnnotationCheck<CheckWith> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreIfNull;
    private SimpleCheck simpleCheck;

    @Override
    public void configure(CheckWith constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setSimpleCheck(constraintAnnotation.value());
        this.setIgnoreIfNull(constraintAnnotation.ignoreIfNull());
    }

    public SimpleCheck getSimpleCheck() {
        return this.simpleCheck;
    }

    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) throws ReflectionException {
        if (valueToValidate == null && this.ignoreIfNull) {
            return true;
        }
        return this.simpleCheck.isSatisfied(validatedObject, valueToValidate);
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
        this.requireMessageVariablesRecreation();
    }

    public void setSimpleCheck(Class<? extends SimpleCheck> simpleCheckType) throws ReflectionException, IllegalArgumentException {
        Assert.notNull("simpleCheckType", simpleCheckType);
        try {
            Constructor<? extends SimpleCheck> ctor = simpleCheckType.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            this.simpleCheck = ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ReflectionException("Cannot instantiate an object of type  " + simpleCheckType.getName(), ex);
        }
        this.requireMessageVariablesRecreation();
    }

    public void setSimpleCheck(SimpleCheck simpleCheck) throws IllegalArgumentException {
        Assert.notNull("simpleCheck", simpleCheck);
        this.simpleCheck = simpleCheck;
        this.requireMessageVariablesRecreation();
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(4);
        messageVariables.put("ignoreIfNull", Boolean.toString(this.ignoreIfNull));
        messageVariables.put("simpleCheck", this.simpleCheck.getClass().getName());
        return messageVariables;
    }

    public static interface SimpleCheck
    extends Serializable {
        public boolean isSatisfied(Object var1, Object var2);
    }
}

