/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.MathUtils;

public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;
    private final TextBlock desc;
    private TextBlock stereo;
    private final boolean hideText;
    private final Collection<Link> links;
    private final boolean useRankSame = this.getSkinParam().useRankSame();
    private final boolean fixCircleLabelOverlapping;
    private final Bibliotekon bibliotekon;
    private final Fashion ctx;

    public EntityImageDescription(Entity entity, ISkinParam skinParam2, PortionShower portionShower, Collection<Link> links, SName styleName, Bibliotekon bibliotekon) {
        super(entity, entity.getColors().mute(skinParam2));
        this.bibliotekon = bibliotekon;
        this.fixCircleLabelOverlapping = this.getSkinParam().fixCircleLabelOverlapping();
        this.links = links;
        USymbol symbol = this.getUSymbol(entity);
        this.shapeType = symbol == USymbols.FOLDER ? ShapeType.FOLDER : (symbol == USymbols.HEXAGON ? ShapeType.HEXAGON : (symbol == USymbols.INTERFACE ? (this.getSkinParam().fixCircleLabelOverlapping() ? ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE : ShapeType.RECTANGLE) : ShapeType.RECTANGLE));
        this.hideText = symbol == USymbols.INTERFACE;
        this.url = entity.getUrl99();
        Colors colors = entity.getColors();
        StyleSignatureBasic tmp = StyleSignatureBasic.of(SName.root, SName.element, styleName, symbol.getSName(), SName.title);
        Stereotype stereotype = entity.getStereotype();
        Style styleTitle = tmp.withTOBECHANGED(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder()).eventuallyOverride(colors);
        Style styleStereo = tmp.forStereotypeItself(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        Style style = StyleSignatureBasic.of(SName.root, SName.element, styleName, symbol.getSName()).withTOBECHANGED(stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder()).eventuallyOverride(colors);
        HColor forecolor = styleTitle.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = styleTitle.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        double roundCorner = styleTitle.value(PName.RoundCorner).asDouble();
        double diagonalCorner = styleTitle.value(PName.DiagonalCorner).asDouble();
        double deltaShadow = styleTitle.value(PName.Shadowing).asDouble();
        UStroke stroke = styleTitle.getStroke(colors);
        FontConfiguration fcTitle = styleTitle.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        FontConfiguration fcStereo = styleStereo.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment defaultAlign = styleTitle.getHorizontalAlignment();
        assert (this.getStereo() == stereotype);
        this.ctx = new Fashion(backcolor, forecolor).withStroke(stroke).withShadow(deltaShadow).withCorner(roundCorner, diagonalCorner);
        Display codeDisplay = Display.getWithNewlines(entity.getName());
        this.desc = entity.getDisplay().equalsLike(codeDisplay) && symbol.getSName() == SName.package_ || entity.getDisplay().isWhite() ? TextBlockUtils.empty(style.value(PName.MinimumWidth).asDouble(), 0.0) : BodyFactory.create3(entity.getDisplay(), this.getSkinParam(), defaultAlign, fcTitle, style.wrapWidth(), styleTitle);
        this.stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite(this.getSkinParam()) != null) {
            this.stereo = stereotype.getSprite(this.getSkinParam());
        } else if (stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(fcStereo, HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(HorizontalAlignment.CENTER), codeDisplay, this.getSkinParam(), stereotype, entity, styleTitle);
        this.asSmall = this.hideText ? symbol.asSmall(TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), this.ctx, this.getSkinParam().getStereotypeAlignment()) : symbol.asSmall(this.name, this.desc, this.stereo, this.ctx, this.getSkinParam().getStereotypeAlignment());
    }

    private USymbol getUSymbol(Entity entity) {
        USymbol result = entity.getUSymbol() == null ? this.getSkinParam().componentStyle().toUSymbol() : entity.getUSymbol();
        return Objects.requireNonNull(result);
    }

    public XDimension2D getNameDimension(StringBounder stringBounder) {
        if (this.hideText) {
            return new XDimension2D(0.0, 0.0);
        }
        return this.name.calculateDimension(stringBounder);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        if (!this.hideText) {
            return Margins.NONE;
        }
        if (this.isThereADoubleLink(this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (!this.fixCircleLabelOverlapping && this.hasSomeHorizontalLinkVisible(this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (this.hasSomeHorizontalLinkDoubleDecorated(this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        XDimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
        XDimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        XDimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
        double x = Math.max(dimStereo.getWidth(), dimDesc.getWidth());
        double suppX = x - dimSmall.getWidth();
        if (suppX < 1.0) {
            suppX = 1.0;
        }
        double y = MathUtils.max(1.0, dimDesc.getHeight(), dimStereo.getHeight());
        return new Margins(suppX / 2.0, suppX / 2.0, y, y);
    }

    private boolean hasSomeHorizontalLinkVisible(Entity leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || link.isInvis()) continue;
            return true;
        }
        return false;
    }

    private boolean isThereADoubleLink(Entity leaf, Collection<Link> links) {
        HashSet<Entity> others = new HashSet<Entity>();
        for (Link link : links) {
            Entity other;
            boolean changed;
            if (!link.contains(leaf) || (changed = others.add(other = link.getOther(leaf)))) continue;
            return true;
        }
        return false;
    }

    private boolean hasSomeHorizontalLinkDoubleDecorated(Entity leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || !link.getType().isDoubleDecorated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("entity " + this.getEntity().getName()));
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getName() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getName());
        ug.startGroup(typeIDent);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.shapeType == ShapeType.HEXAGON) {
            this.drawHexagon(this.ctx.apply(ug));
        }
        this.asSmall.drawU(ug);
        if (this.hideText) {
            double space = 8.0;
            XDimension2D dimSmall = this.asSmall.calculateDimension(ug.getStringBounder());
            XDimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            UGraphic ugDesc = ug.apply(new UTranslate(posx1, 8.0 + dimSmall.getHeight()));
            ugDesc = UGraphicStencil.create(ugDesc, dimDesc);
            this.desc.drawU(ugDesc);
            XDimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(new UTranslate(posx2, -8.0 - dimStereo.getHeight())));
        }
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private void drawHexagon(UGraphic ug) {
        if (this.bibliotekon == null) {
            throw new IllegalStateException();
        }
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable hexagon = node.getPolygon();
        if (hexagon != null) {
            hexagon.setDeltaShadow(this.ctx.getDeltaShadow());
            ug.draw(hexagon);
        }
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        if (this.hideText) {
            XDimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
            XDimension2D dimDesc = this.desc.calculateDimension(stringBounder);
            XDimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            return MathUtils.max(-posx1, -posx2, 0.0);
        }
        return 0.0;
    }

    @Override
    public MagneticBorder getMagneticBorder() {
        if (this.shapeType == ShapeType.FOLDER) {
            return this.asSmall.getMagneticBorder();
        }
        return new MagneticBorderNone();
    }
}

