/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public final class RoundedNorth
implements UDrawable {
    private final double width;
    private final double height;
    private final HColor backColor;
    private final double rounded;

    public RoundedNorth(double width, double height, HColor backColor, double rounded) {
        if (width == 0.0) {
            throw new IllegalArgumentException();
        }
        if (height == 0.0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.rounded = rounded;
        this.backColor = backColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        AbstractShadowable header;
        if (this.backColor.isTransparent()) {
            return;
        }
        if (this.rounded == 0.0) {
            header = new URectangle(this.width, this.height);
        } else {
            UPath path = new UPath();
            path.moveTo(this.rounded / 2.0, 0.0);
            path.lineTo(this.width - this.rounded / 2.0, 0.0);
            path.arcTo(this.rounded / 2.0, this.rounded / 2.0, 0.0, 0.0, 1.0, this.width, this.rounded / 2.0);
            path.lineTo(this.width, this.height);
            path.lineTo(0.0, this.height);
            path.lineTo(0.0, this.rounded / 2.0);
            path.arcTo(this.rounded / 2.0, this.rounded / 2.0, 0.0, 0.0, 1.0, this.rounded / 2.0, 0.0);
            path.closePath();
            header = path;
        }
        ug.apply(new UStroke()).apply(this.backColor).apply(this.backColor.bg()).draw(header);
    }
}

