/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class ActorAwesome
extends AbstractTextBlock
implements TextBlock {
    private final double headDiam = 32.0;
    private final double bodyWidth = 54.0;
    private final double shoulder = 16.0;
    private final double collar = 4.0;
    private final double radius = 8.0;
    private final double bodyHeight = 28.0;
    private final Fashion symbolContext;

    public ActorAwesome(Fashion symbolContext) {
        this.symbolContext = symbolContext.withStroke(new UStroke(1.5));
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = new UEllipse(32.0, 32.0);
        double centerX = this.getPreferredWidth() / 2.0;
        UPath path = new UPath();
        path.moveTo(0.0, 4.0);
        path.cubicTo(4.0, 4.0, 7.0, 4.0, 11.0, 0.0);
        path.cubicTo(19.0, 0.0, 27.0, 8.0, 27.0, 16.0);
        path.lineTo(27.0, 20.0);
        path.cubicTo(27.0, 24.0, 23.0, 28.0, 19.0, 28.0);
        path.lineTo(-19.0, 28.0);
        path.cubicTo(-23.0, 28.0, -27.0, 24.0, -27.0, 20.0);
        path.lineTo(-27.0, 16.0);
        path.cubicTo(-27.0, 8.0, -19.0, 0.0, -11.0, 0.0);
        path.cubicTo(-7.0, 4.0, -4.0, 4.0, 0.0, 4.0);
        path.closePath();
        if (this.symbolContext.getDeltaShadow() != 0.0) {
            head.setDeltaShadow(this.symbolContext.getDeltaShadow());
            path.setDeltaShadow(this.symbolContext.getDeltaShadow());
        }
        ug = this.symbolContext.apply(ug);
        ug.apply(new UTranslate(centerX - head.getWidth() / 2.0, this.thickness())).draw(head);
        ug.apply(new UTranslate(centerX, head.getHeight() + this.thickness())).draw(path);
    }

    private double thickness() {
        return this.symbolContext.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return 54.0 + this.thickness() * 2.0;
    }

    public double getPreferredHeight() {
        return 60.0 + this.thickness() * 2.0;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

