/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShapeSized;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.compress.CompressionMode;
import net.sourceforge.plantuml.klimt.compress.UShapeIgnorableForCompression;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UEmpty;

public class URectangle
extends AbstractShadowable
implements UShapeSized,
UShapeIgnorableForCompression {
    private final double width;
    private final double height;
    private final double rx;
    private final double ry;
    private final String comment;
    private final String codeLine;
    private final boolean ignoreForCompressionOnX;
    private final boolean ignoreForCompressionOnY;

    public URectangle withHeight(double newHeight) {
        URectangle result = new URectangle(this.width, newHeight, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY, this.codeLine);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle withWidth(double newWidth) {
        URectangle result = new URectangle(newWidth, this.height, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY, this.codeLine);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle withCommentAndCodeLine(String comment, String codeLine) {
        return new URectangle(this.width, this.height, this.rx, this.ry, comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY, codeLine);
    }

    public URectangle rounded(double round) {
        return new URectangle(this.width, this.height, round, round, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY, this.codeLine);
    }

    public Shadowable diagonalCorner(double diagonalCorner) {
        if (this.ignoreForCompressionOnX || this.ignoreForCompressionOnY) {
            throw new IllegalStateException();
        }
        if (diagonalCorner == 0.0) {
            return this;
        }
        UPath result = new UPath();
        result.moveTo(diagonalCorner, 0.0);
        result.lineTo(this.width - diagonalCorner, 0.0);
        result.lineTo(this.width, diagonalCorner);
        result.lineTo(this.width, this.height - diagonalCorner);
        result.lineTo(this.width - diagonalCorner, this.height);
        result.lineTo(diagonalCorner, this.height);
        result.lineTo(0.0, this.height - diagonalCorner);
        result.lineTo(0.0, diagonalCorner);
        result.lineTo(diagonalCorner, 0.0);
        return result;
    }

    public final URectangle ignoreForCompressionOnX() {
        return new URectangle(this.width, this.height, this.rx, this.ry, this.comment, true, this.ignoreForCompressionOnY, this.codeLine);
    }

    public final URectangle ignoreForCompressionOnY() {
        return new URectangle(this.width, this.height, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, true, this.codeLine);
    }

    public URectangle(double width, double height) {
        this(width, height, 0.0, 0.0, null, false, false, null);
    }

    public URectangle(XDimension2D dim) {
        this(dim.getWidth(), dim.getHeight());
    }

    private URectangle(double width, double height, double rx, double ry, String comment, boolean ignoreForCompressionOnX, boolean ignoreForCompressionOnY, String codeLine) {
        if (height == 0.0) {
            throw new IllegalArgumentException("height=" + height);
        }
        if (width == 0.0) {
            throw new IllegalArgumentException("width=" + width);
        }
        this.ignoreForCompressionOnX = ignoreForCompressionOnX;
        this.ignoreForCompressionOnY = ignoreForCompressionOnY;
        this.comment = comment;
        this.codeLine = codeLine;
        this.width = width;
        this.height = height;
        this.rx = rx;
        this.ry = ry;
    }

    public String toString() {
        return "width=" + this.width + " height=" + this.height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    public URectangle clip(UClip clip) {
        return this;
    }

    public MinMax getMinMax() {
        return MinMax.fromMax(this.width, this.height);
    }

    public final String getComment() {
        return this.comment;
    }

    public String getCodeLine() {
        return this.codeLine;
    }

    @Override
    public void drawWhenCompressed(UGraphic ug, CompressionMode mode) {
        if (mode == CompressionMode.ON_X) {
            ug.draw(new UEmpty(2.0, this.getHeight()));
            ug.apply(UTranslate.dx(this.getWidth() - 2.0)).draw(new UEmpty(2.0, this.getHeight()));
        }
        if (mode == CompressionMode.ON_Y) {
            ug.draw(new UEmpty(this.getWidth(), 2.0));
            ug.apply(UTranslate.dy(this.getHeight() - 2.0)).draw(new UEmpty(this.getWidth(), 2.0));
        }
    }

    @Override
    public boolean isIgnoreForCompressionOn(CompressionMode mode) {
        if (mode == CompressionMode.ON_X) {
            return this.ignoreForCompressionOnX;
        }
        if (mode == CompressionMode.ON_Y) {
            return this.ignoreForCompressionOnY;
        }
        throw new IllegalArgumentException();
    }
}

