/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.hand;

import java.util.Random;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.drawing.hand.HandJiggle;
import net.sourceforge.plantuml.klimt.geom.USegment;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class UPathHand {
    private final UPath path;
    private final double defaultVariation = 4.0;

    public UPathHand(UPath source, Random rnd) {
        UPath result = new UPath();
        XPoint2D last = new XPoint2D();
        for (USegment segment : source) {
            HandJiggle jiggle;
            double y;
            double x;
            USegmentType type = segment.getSegmentType();
            if (type == USegmentType.SEG_MOVETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                result.moveTo(x, y);
                last = new XPoint2D(x, y);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                double x2 = segment.getCoord()[4];
                double y2 = segment.getCoord()[5];
                jiggle = HandJiggle.create(last, 2.0, rnd);
                XCubicCurve2D tmp = new XCubicCurve2D(last.getX(), last.getY(), segment.getCoord()[0], segment.getCoord()[1], segment.getCoord()[2], segment.getCoord()[3], x2, y2);
                jiggle.curveTo(tmp);
                jiggle.appendTo(result);
                last = new XPoint2D(x2, y2);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                jiggle = new HandJiggle(last.getX(), last.getY(), 4.0, rnd);
                jiggle.lineTo(x, y);
                for (USegment seg2 : jiggle.toUPath()) {
                    if (seg2.getSegmentType() != USegmentType.SEG_LINETO) continue;
                    result.lineTo(seg2.getCoord()[0], seg2.getCoord()[1]);
                }
                last = new XPoint2D(x, y);
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                x = segment.getCoord()[5];
                y = segment.getCoord()[6];
                result.lineTo(x, y);
                last = new XPoint2D(x, y);
                continue;
            }
            this.path = source;
            return;
        }
        this.path = result;
        this.path.setDeltaShadow(source.getDeltaShadow());
    }

    public UPath getHanddrawn() {
        return this.path;
    }
}

