/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;

public class ActivityBox
extends AbstractTextBlock {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final Tile tile;
    private final String id;
    private final String label;
    private final TextBlock tb;

    public ActivityBox(Tile tile, String id, String label) {
        this.tile = tile;
        this.id = id;
        this.label = label;
        UFont font = UFont.serif(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        this.tb = Display.create(label).create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public Tile getTile() {
        return this.tile;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(25.0);
        ug = ug.apply(HColors.MY_RED);
        ug = ug.apply(HColors.MY_YELLOW.bg());
        ug.apply(new UStroke(1.5)).draw(rect);
        this.tb.drawU(ug.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.tb.calculateDimension(stringBounder);
        return dim.delta(20.0, 20.0);
    }
}

