/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionSpot;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileAssembly;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileEmpty;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.style.ISkinParam;

public class InstructionList
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Instruction> all = new ArrayList<Instruction>();
    private final Swimlane defaultSwimlane;
    private LinkRendering outlinkRendering;

    @Override
    public boolean containsBreak() {
        for (Instruction ins : this.all) {
            if (!ins.containsBreak()) continue;
            return true;
        }
        return false;
    }

    public static InstructionList empty() {
        return new InstructionList(null);
    }

    public InstructionList(Swimlane defaultSwimlane) {
        this.defaultSwimlane = defaultSwimlane;
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public boolean isOnlySingleStopOrSpot() {
        if (this.all.size() != 1) {
            return false;
        }
        if (this.getLast() instanceof InstructionSpot) {
            return true;
        }
        return this.getLast() instanceof InstructionStop && !((InstructionStop)this.getLast()).hasNotes();
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        this.all.add(ins);
        return CommandExecutionResult.ok();
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        if (this.all.size() == 0) {
            return new GtileEmpty(stringBounder, skinParam, this.defaultSwimlane);
        }
        Gtile result = null;
        for (Instruction ins : this.all) {
            Gtile cur = ins.createGtile(skinParam, stringBounder);
            if (result == null) {
                result = cur;
                continue;
            }
            result = new GtileAssembly(result, cur, ins.getInLinkRendering());
        }
        return result;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        if (this.all.size() == 0) {
            return new FtileEmpty(factory.skinParam(), this.defaultSwimlane);
        }
        ArrayList<WeldingPoint> breaks = new ArrayList<WeldingPoint>();
        Ftile result = this.eventuallyAddNote(factory, null, this.getSwimlaneIn(), VerticalAlignment.CENTER);
        for (Instruction ins : this.all) {
            Ftile cur = ins.createFtile(factory);
            breaks.addAll(cur.getWeldingPoints());
            if (!ins.getInLinkRendering().isNone()) {
                cur = factory.decorateIn(cur, ins.getInLinkRendering());
            }
            if (result == null) {
                result = cur;
                continue;
            }
            result = factory.assembly(result, cur);
        }
        if (this.outlinkRendering != null) {
            result = factory.decorateOut(result, this.outlinkRendering);
        }
        if (breaks.size() > 0) {
            result = new FtileDecorateWelding(result, breaks);
        }
        return result;
    }

    @Override
    public final boolean kill() {
        if (this.all.size() == 0) {
            return false;
        }
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.all.iterator().next().getInLinkRendering();
    }

    @Override
    public Instruction getLast() {
        if (this.all.size() == 0) {
            return null;
        }
        return this.all.get(this.all.size() - 1);
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.getLast() == null) {
            return super.addNote(note, position, type, colors, swimlaneNote);
        }
        return this.getLast().addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.all);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.defaultSwimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        Set<Swimlane> swimlanes = this.getSwimlanes();
        if (swimlanes.size() == 0) {
            return null;
        }
        if (swimlanes.size() == 1) {
            return swimlanes.iterator().next();
        }
        return this.getLast().getSwimlaneOut();
    }

    public static Set<Swimlane> getSwimlanes2(List<? extends Instruction> list) {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Instruction instruction : list) {
            result.addAll(instruction.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    public void setOutRendering(LinkRendering outlinkRendering) {
        this.outlinkRendering = outlinkRendering;
    }
}

