/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderYearly
extends TimeHeaderCalendar {
    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        return h1 + 3.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        return h1 + 3.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder);
    }

    public TimeHeaderYearly(StringBounder stringBounder, TimeHeaderParameters thParam) {
        super(thParam, new TimeScaleCompressed(thParam.getCellWidth(stringBounder), thParam.getStartingDay(), thParam.getScale()));
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getTimeFooterHeight(ug.getStringBounder()));
    }

    private void drawYears(UGraphic ug) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h1 + 2.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.getMax().increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getEndingPosition(this.getMax()), 0.0, h1 + 2.0);
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.year, "" + monthYear.year(), true, this.openFontColor());
        this.printCentered(ug, true, start, end, small);
    }
}

