/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandParticipant;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandParticipantMultilines
extends CommandMultilines2<SequenceDiagram> {
    public CommandParticipantMultilines() {
        super(CommandParticipantMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^([^\\[\\]]*)\\]$";
    }

    private static RegexConcat getRegexConcat() {
        return RegexConcat.build(CommandParticipantMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(participant)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.@]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), CommandParticipant.getOrderRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(SequenceDiagram diagram, BlocLines lines) throws NoSuchColorException {
        String urlString;
        RegexResult arg = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String code = arg.get("CODE", 0);
        if (diagram.participantsContainsKey(code)) {
            diagram.putParticipantInLast(code);
            return CommandExecutionResult.ok();
        }
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display strings = lines.toDisplay();
        ParticipantType type = ParticipantType.PARTICIPANT;
        boolean create = false;
        String orderString = arg.get("ORDER", 0);
        int order = orderString == null ? 0 : Integer.parseInt(orderString);
        Participant participant = diagram.createNewParticipant(type, code, strings, order);
        String stereotype = arg.get("STEREO", 0);
        if (stereotype != null) {
            ISkinParam skinParam = diagram.getSkinParam();
            boolean stereotypePositionTop = skinParam.stereotypePositionTop();
            UFont font = skinParam.getFont(null, false, FontParam.CIRCLED_CHARACTER);
            participant.setStereotype(Stereotype.build(stereotype, skinParam.getCircledCharacterRadius(), font, diagram.getSkinParam().getIHtmlColorSet()), stereotypePositionTop);
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            participant.setUrl(url);
        }
        return CommandExecutionResult.ok();
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }
}

