/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandBoxStart
extends SingleLineCommand2<SequenceDiagram> {
    public CommandBoxStart() {
        super(CommandBoxStart.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandBoxStart.class.getName(), RegexLeaf.start(), new RegexLeaf("box"), new RegexOptional((IRegex)new RegexOr(new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME1", "[%g]([^%g]+)[%g]")), new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME2", "([^#]+)")))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), CommandBoxStart.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String argTitle = arg.getLazzy("NAME", 0);
        String argColor = arg.get("COLOR", 0);
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereo != null) {
            ISkinParam skinParam = diagram.getSkinParam();
            stereotype = Stereotype.build(stereo);
        }
        Colors colors = CommandBoxStart.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String title = argTitle == null ? "" : argTitle;
        diagram.boxStart(Display.getWithNewlines(title), colors.getColor(ColorType.BACK), stereotype);
        return CommandExecutionResult.ok();
    }
}

