/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.regex.Matcher;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String endingGroup() {
        return "(;(?:[%s]*\\<\\<\\w+\\>\\>)?|" + Matcher.quoteReplacement("\\\\") + "|(?<![/|<}\\]])[/<}]|(?<![/|}\\]])\\]|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)\\>|(?<!\\|.{1,999})\\|)";
    }

    private static final String endingGroupShort() {
        return "(;(?:[%s]*\\<\\<\\w+\\>\\>)?|" + Matcher.quoteReplacement("\\\\") + "|(?<![/|<}\\]])[/<}]|(?<![/|}\\]])\\]|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)\\>|\\|)";
    }

    public static void main(String[] args) {
        System.err.println(Matcher.quoteReplacement("\\\\"));
        System.err.println(Matcher.quoteReplacement("\\\\").equals("\\\\\\\\"));
    }

    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivity3.class.getName(), RegexLeaf.start(), UrlBuilder.OPTIONAL, CommandActivity3.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*?)"), new RegexLeaf("STYLE", CommandActivity3.endingGroupShort()), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Url url;
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Colors colors = CommandActivity3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
            colors = colors.applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.activityBackground);
        }
        BoxStyle style = BoxStyle.fromString(arg.get("STYLE", 0));
        Display display = Display.getWithNewlines2(arg.get("LABEL", 0));
        return diagram.addActivity(display, style, url, colors, stereotype);
    }
}

