/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class WElement {
    private final HColor backColor;
    private final Display label;
    private final int level;
    private final String stereotype;
    private final WElement parent;
    private final StyleBuilder styleBuilder;
    private final List<WElement> childrenLeft = new ArrayList<WElement>();
    private final List<WElement> childrenRight = new ArrayList<WElement>();
    private final IdeaShape shape;
    private UTranslate position;
    private XDimension2D dimension;
    public static final int STEP_BY_PARENT = 10001000;

    private StyleSignatureBasic getDefaultStyleDefinitionNode(int level) {
        String depth = SName.depth(level);
        if (level == 0) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.rootNode).addS(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE && this.isLeaf()) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode, SName.boxless).addS(this.stereotype).add(depth);
        }
        if (this.isLeaf()) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode).addS(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.boxless).addS(this.stereotype).add(depth);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node).addS(this.stereotype).add(depth);
    }

    public ISkinParam withBackColor(ISkinParam skinParam) {
        if (this.backColor == null) {
            return skinParam;
        }
        return new SkinParamColors(skinParam, Colors.empty().add(ColorType.BACK, this.backColor));
    }

    public Style getStyle() {
        int deltaPriority = 1411065408;
        Style result = this.styleBuilder.getMergedStyleSpecial(this.getDefaultStyleDefinitionNode(this.level), deltaPriority);
        WElement up = this.parent;
        while (up != null) {
            StyleSignatureBasic ss = up.getDefaultStyleDefinitionNode(this.level).addStar();
            Style styleParent = this.styleBuilder.getMergedStyleSpecial(ss, deltaPriority -= 10001000);
            result = result.mergeWith(styleParent, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            up = up.parent;
        }
        return result;
    }

    public WElement(HColor backColor, Display label, String stereotype, StyleBuilder styleBuilder, IdeaShape shape) {
        this(backColor, 0, label, stereotype, null, shape, styleBuilder);
    }

    private WElement(HColor backColor, int level, Display label, String stereotype, WElement parent, IdeaShape shape, StyleBuilder styleBuilder) {
        this.label = label;
        this.backColor = backColor;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.styleBuilder = styleBuilder;
        this.stereotype = stereotype;
    }

    public boolean isLeaf() {
        return this.childrenLeft.size() == 0 && this.childrenRight.size() == 0;
    }

    public WElement createElement(HColor backColor, int newLevel, Display newLabel, String stereotype, Direction direction, IdeaShape shape, StyleBuilder styleBuilder) {
        WElement result = new WElement(backColor, newLevel, newLabel, stereotype, this, shape, styleBuilder);
        if (direction == Direction.LEFT && newLevel == 1) {
            this.childrenRight.add(0, result);
        }
        if (direction == Direction.LEFT) {
            this.childrenLeft.add(result);
        } else {
            this.childrenRight.add(result);
        }
        return result;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<WElement> getChildren(Direction direction) {
        if (direction == Direction.LEFT) {
            return Collections.unmodifiableList(this.childrenLeft);
        }
        return Collections.unmodifiableList(this.childrenRight);
    }

    public WElement getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public final void setGeometry(UTranslate position, XDimension2D dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    public final UTranslate getPosition() {
        return this.position;
    }

    public final XDimension2D getDimension() {
        return this.dimension;
    }
}

