/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class CommunicationTileNoteBottomTopAbstract
extends AbstractTile {
    protected final Tile tile;
    protected final AbstractMessage message;
    protected final Rose skin;
    protected final ISkinParam skinParam;
    protected final Note noteOnMessage;
    private final YGauge yGauge;
    protected final double spacey = 10.0;

    @Override
    public final Event getEvent() {
        return this.message;
    }

    @Override
    public final double getContactPointRelative() {
        return this.tile.getContactPointRelative();
    }

    public CommunicationTileNoteBottomTopAbstract(Tile tile, AbstractMessage message, Rose skin, ISkinParam skinParam, Note noteOnMessage, YGauge currentY) {
        super(((AbstractTile)tile).getStringBounder(), currentY);
        this.tile = tile;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.noteOnMessage = noteOnMessage;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
        this.tile.callbackY(y);
    }

    protected final Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponentNote(this.noteOnMessage.getUsedStyles(), ComponentType.NOTE, this.noteOnMessage.getSkinParamBackcolored(this.skinParam), this.noteOnMessage.getStrings(), this.noteOnMessage.getColors());
        return comp;
    }

    protected final Real getNotePosition(StringBounder stringBounder) {
        Real minX = this.tile.getMinX();
        return minX;
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor color = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double dx = x2 - x1;
        double dy = y2 - y1;
        ug.apply(new UTranslate(x1, y1)).apply(color).apply(new UStroke(2.0, 2.0, 1.0)).draw(new ULine(dx, dy));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return this.tile.getPreferredHeight() + dim.getHeight() + 10.0;
    }

    @Override
    public void addConstraints() {
        this.tile.addConstraints();
    }

    @Override
    public Real getMinX() {
        return this.tile.getMinX();
    }

    @Override
    public Real getMaxX() {
        return this.tile.getMaxX();
    }
}

