/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class GraphvizVersionFinder {
    private final File dotExe;
    public static final GraphvizVersion DEFAULT = new GraphvizVersion(){

        @Override
        public boolean useShieldForQuantifier() {
            return true;
        }

        @Override
        public boolean useProtectionWhenThereALinkFromOrToGroup() {
            return true;
        }

        @Override
        public boolean useXLabelInsteadOfLabel() {
            return false;
        }

        @Override
        public boolean isVizjs() {
            return false;
        }

        @Override
        public boolean ignoreHorizontalLinks() {
            return false;
        }
    };

    public GraphvizVersionFinder(File dotExe) {
        this.dotExe = dotExe;
    }

    public GraphvizVersion getVersion() {
        String dotVersion = this.dotVersion();
        Pattern p = Pattern.compile("(\\d)\\.(\\d\\d?)");
        Matcher m = p.matcher(dotVersion);
        boolean find = m.find();
        if (!find) {
            return DEFAULT;
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        final int v = 100 * major + minor;
        return new GraphvizVersion(){

            @Override
            public boolean useShieldForQuantifier() {
                return v <= 228;
            }

            @Override
            public boolean useProtectionWhenThereALinkFromOrToGroup() {
                return v != 239 && v != 240;
            }

            @Override
            public boolean useXLabelInsteadOfLabel() {
                return false;
            }

            @Override
            public boolean isVizjs() {
                return false;
            }

            @Override
            public boolean ignoreHorizontalLinks() {
                return v == 230;
            }
        };
    }

    public String dotVersion() {
        String[] cmd = this.getCommandLine();
        ProcessRunner p = new ProcessRunner(cmd);
        ProcessState state = p.run(null, null);
        if (state.differs(ProcessState.TERMINATED_OK())) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty(p.getOut())) {
            sb.append(p.getOut());
        }
        if (StringUtils.isNotEmpty(p.getError())) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(p.getError());
        }
        return StringUtils.trin(sb.toString().replace('\n', ' '));
    }

    private String[] getCommandLine() {
        return new String[]{this.dotExe.getAbsolutePath(), "-V"};
    }
}

