/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.zopfli;

public class Buffer {
    byte[] data = new byte[65536];
    int size;
    private int bp;

    Buffer() {
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getResult() {
        byte[] copy = new byte[this.size];
        System.arraycopy(this.data, 0, copy, 0, this.size);
        return copy;
    }

    public int getSize() {
        return this.size;
    }

    void append(byte value) {
        if (this.size == this.data.length) {
            byte[] copy = new byte[this.size * 2];
            System.arraycopy(this.data, 0, copy, 0, this.size);
            this.data = copy;
        }
        this.data[this.size++] = value;
    }

    void addBits(int symbol, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.bp == 0) {
                this.append((byte)0);
            }
            int bit = symbol >> i & 1;
            int n = this.size - 1;
            this.data[n] = (byte)(this.data[n] | bit << this.bp);
            this.bp = this.bp + 1 & 7;
        }
    }

    void addHuffmanBits(int symbol, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.bp == 0) {
                this.append((byte)0);
            }
            int bit = symbol >> length - i - 1 & 1;
            int n = this.size - 1;
            this.data[n] = (byte)(this.data[n] | bit << this.bp);
            this.bp = this.bp + 1 & 7;
        }
    }
}

