/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ebnf.Symbol;
import net.sourceforge.plantuml.ebnf.Token;

public class ShuntingYard {
    private final List<Token> ouputQueue = new ArrayList<Token>();
    private final Deque<Token> operatorStack = new ArrayDeque<Token>();

    public ShuntingYard(Iterator<Token> it) {
        Token token;
        while (it.hasNext()) {
            Token first;
            token = it.next();
            if (token.getSymbol() == Symbol.LITTERAL || token.getSymbol() == Symbol.TERMINAL_STRING1 || token.getSymbol() == Symbol.TERMINAL_STRING2 || token.getSymbol() == Symbol.SPECIAL_SEQUENCE) {
                this.ouputQueue.add(token);
                while (this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstAbove());
                }
                continue;
            }
            if (token.getSymbol() == Symbol.COMMENT_TOKEN) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getSymbol().isOperator()) {
                while (this.thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(token) || this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstBelow());
                }
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getSymbol() == Symbol.GROUPING_OPEN) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getSymbol() == Symbol.GROUPING_CLOSE) {
                while (this.operatorStack.peekFirst().getSymbol() != Symbol.GROUPING_OPEN) {
                    this.ouputQueue.add(this.operatorStack_removeFirstBelow());
                }
                if (this.operatorStack.peekFirst().getSymbol() != Symbol.GROUPING_OPEN) continue;
                this.operatorStack.removeFirst();
                continue;
            }
            if (token.getSymbol() == Symbol.OPTIONAL_OPEN) {
                this.operatorStack.addFirst(new Token(Symbol.OPTIONAL, null));
                continue;
            }
            if (token.getSymbol() == Symbol.OPTIONAL_CLOSE) {
                while (this.thereIsAnOperatorAtTheTopOfTheOperatorStack() || this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstBelow());
                }
                first = this.operatorStack.removeFirst();
                if (first.getSymbol() != Symbol.OPTIONAL) {
                    throw new IllegalStateException();
                }
                this.ouputQueue.add(first);
                while (this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstAbove());
                }
                continue;
            }
            if (token.getSymbol() == Symbol.REPETITION_OPEN) {
                this.operatorStack.addFirst(new Token(Symbol.REPETITION_ZERO_OR_MORE, null));
                continue;
            }
            if (token.getSymbol() == Symbol.REPETITION_CLOSE) {
                while (this.thereIsAnOperatorAtTheTopOfTheOperatorStack() || this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstBelow());
                }
                first = this.operatorStack.removeFirst();
                if (first.getSymbol() != Symbol.REPETITION_ZERO_OR_MORE) {
                    throw new IllegalStateException();
                }
                this.ouputQueue.add(first);
                while (this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstAbove());
                }
                continue;
            }
            if (token.getSymbol() == Symbol.REPETITION_MINUS_CLOSE) {
                while (this.thereIsAnOperatorAtTheTopOfTheOperatorStack() || this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstBelow());
                }
                first = this.operatorStack.removeFirst();
                if (first.getSymbol() != Symbol.REPETITION_ZERO_OR_MORE) {
                    throw new IllegalStateException();
                }
                this.ouputQueue.add(new Token(Symbol.REPETITION_ONE_OR_MORE, null));
                while (this.thereIsAnCommentOnTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack_removeFirstAbove());
                }
                continue;
            }
            throw new UnsupportedOperationException(token.toString());
        }
        while (!this.operatorStack.isEmpty()) {
            token = this.operatorStack.removeFirst();
            if (token.getSymbol() == Symbol.OPTIONAL || token.getSymbol() == Symbol.REPETITION_ONE_OR_MORE || token.getSymbol() == Symbol.REPETITION_ZERO_OR_MORE) {
                this.ouputQueue.clear();
                return;
            }
            if (token.getSymbol() == Symbol.COMMENT_TOKEN) {
                this.ouputQueue.add(new Token(Symbol.COMMENT_BELOW, token.getData()));
                continue;
            }
            this.ouputQueue.add(token);
        }
    }

    private Token operatorStack_removeFirstAbove() {
        Token result = this.operatorStack.removeFirst();
        if (result.getSymbol() == Symbol.COMMENT_TOKEN) {
            return new Token(Symbol.COMMENT_ABOVE, result.getData());
        }
        return result;
    }

    private Token operatorStack_removeFirstBelow() {
        Token result = this.operatorStack.removeFirst();
        if (result.getSymbol() == Symbol.COMMENT_TOKEN) {
            return new Token(Symbol.COMMENT_BELOW, result.getData());
        }
        return result;
    }

    private boolean thereIsAnCommentOnTopOfTheOperatorStack() {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getSymbol() == Symbol.COMMENT_TOKEN;
    }

    private boolean thereIsAFunctionAtTheTopOfTheOperatorStack() {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getSymbol().isFunction();
    }

    private boolean thereIsAnOperatorAtTheTopOfTheOperatorStack() {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getSymbol().isOperator();
    }

    private boolean thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getSymbol().isOperator() && top.getSymbol().getPriority() > token.getSymbol().getPriority();
    }

    public final List<Token> getOuputQueue() {
        return Collections.unmodifiableList(this.ouputQueue);
    }
}

