/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.cgraph.subg__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_Agraphinfo_t;
import h.ST_Agrec_s;
import h.ST_GVC_s;
import h.ST_boxf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.sdot.SmetanaPath;
import net.sourceforge.plantuml.sdot.YMirror;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.SvekNode;
import smetana.core.CString;
import smetana.core.Globals;
import smetana.core.JUtils;
import smetana.core.Macro;
import smetana.core.debug.SmetanaDebug;

public class CucaDiagramFileMakerSmetana
implements CucaDiagramFileMaker {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;
    private final Map<Entity, ST_Agnode_s> nodes = new LinkedHashMap<Entity, ST_Agnode_s>();
    private final Map<Link, ST_Agedge_s> edges = new LinkedHashMap<Link, ST_Agedge_s>();
    private final Map<Entity, ST_Agraph_s> clusters = new LinkedHashMap<Entity, ST_Agraph_s>();
    private final DotStringFactory dotStringFactory;
    private static final Lock lock = new ReentrantLock();

    private MinMaxMutable getSmetanaMinMax() {
        MinMaxMutable result = MinMaxMutable.getEmpty(false);
        for (ST_Agnode_s n : this.nodes.values()) {
            ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)n.data;
            double width = data.width * 72.0;
            double height = data.height * 72.0;
            double x = data.coord.x;
            double y = data.coord.y;
            result.addPoint(x - width / 2.0, y - height / 2.0);
            result.addPoint(x + width / 2.0, y + height / 2.0);
        }
        for (ST_Agraph_s gr : this.clusters.values()) {
            ST_Agrec_s tmp1 = gr.data;
            if (!(tmp1 instanceof ST_Agraphinfo_t)) {
                System.err.println("ERROR IN CucaDiagramFileMakerSmetana");
                continue;
            }
            ST_Agraphinfo_t data = (ST_Agraphinfo_t)tmp1;
            ST_boxf bb = data.bb;
            double llx = bb.LL.x;
            double lly = bb.LL.y;
            double urx = bb.UR.x;
            double ury = bb.UR.y;
            result.addPoint(llx, lly);
            result.addPoint(urx, ury);
        }
        return result;
    }

    public CucaDiagramFileMakerSmetana(ICucaDiagram diagram, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.dotStringFactory = new DotStringFactory(stringBounder, diagram);
        this.printAllSubgroups(diagram.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
    }

    private void drawGroup(UGraphic ug, YMirror ymirror, Entity group, ST_Agraph_s gr) {
        JUtils.LOG2("drawGroup");
        try {
            ST_Agrec_s tmp1 = gr.data;
            ST_Agraphinfo_t data = (ST_Agraphinfo_t)tmp1;
            ST_boxf bb = data.bb;
            double llx = bb.LL.x;
            double ury = ymirror.getMirrored(bb.LL.y);
            double lly = ymirror.getMirrored(bb.UR.y);
            double urx = bb.UR.x;
            Cluster cluster = this.dotStringFactory.getBibliotekon().getCluster(group);
            cluster.setPosition(new XPoint2D(llx, lly), new XPoint2D(urx, ury));
            XDimension2D dimTitle = cluster.getTitleDimension(ug.getStringBounder());
            if (dimTitle != null) {
                double x = (llx + urx) / 2.0 - dimTitle.getWidth() / 2.0;
                cluster.setTitlePosition(new XPoint2D(x, lly));
            }
            JUtils.LOG2("cluster=" + cluster);
            cluster.drawU(ug, this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        }
        catch (Exception e) {
            System.err.println("CANNOT DRAW GROUP");
        }
    }

    private void printAllSubgroups(Entity parent) {
        for (Entity g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                g.muteToType(LeafType.EMPTY_PACKAGE);
                this.printEntityNew(g);
                continue;
            }
            this.printSingleGroup(g);
        }
    }

    private void printSingleGroup(Entity g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        ClusterHeader clusterHeader = new ClusterHeader(g, this.diagram.getSkinParam(), this.diagram, this.stringBounder);
        this.dotStringFactory.openCluster(g, clusterHeader);
        this.printEntities(g.leafs());
        this.printAllSubgroups(g);
        this.dotStringFactory.closeCluster();
    }

    private void printEntities(Collection<Entity> entities) {
        for (Entity ent : entities) {
            if (ent.isRemoved()) continue;
            this.printEntity(ent);
        }
    }

    private void exportEntities(Globals zz, ST_Agraph_s g, Collection<Entity> entities) {
        for (Entity ent : entities) {
            if (ent.isRemoved()) continue;
            this.exportEntity(zz, g, ent);
        }
    }

    private void exportEntity(Globals zz, ST_Agraph_s g, Entity leaf) {
        SvekNode node = this.dotStringFactory.getBibliotekon().getNode(leaf);
        if (node == null) {
            System.err.println("CANNOT FIND NODE");
            return;
        }
        ST_Agnode_s agnode = node__c.agnode(zz, g, new CString(node.getUid()), true);
        attr__c.agsafeset(zz, agnode, new CString("shape"), new CString("box"), new CString(""));
        String width = "" + node.getWidth() / 72.0;
        String height = "" + node.getHeight() / 72.0;
        attr__c.agsafeset(zz, agnode, new CString("width"), new CString(width), new CString(""));
        attr__c.agsafeset(zz, agnode, new CString("height"), new CString(height), new CString(""));
        this.nodes.put(leaf, agnode);
    }

    private void printEntity(Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(ent);
        SvekNode node = this.getBibliotekon().createNode(ent, image, this.dotStringFactory.getColorSequence(), this.stringBounder);
        this.dotStringFactory.addNode(node);
    }

    private Collection<Entity> getUnpackagedEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ent : this.diagram.getEntityFactory().leafs()) {
            if (this.diagram.getEntityFactory().getRootGroup() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printCluster(Globals zz, ST_Agraph_s g, Cluster cluster) {
        for (SvekNode node : cluster.getNodes()) {
            ST_Agnode_s agnode = node__c.agnode(zz, g, new CString(node.getUid()), true);
            attr__c.agsafeset(zz, agnode, new CString("shape"), new CString("box"), new CString(""));
            String width = "" + node.getWidth() / 72.0;
            String height = "" + node.getHeight() / 72.0;
            attr__c.agsafeset(zz, agnode, new CString("width"), new CString(width), new CString(""));
            attr__c.agsafeset(zz, agnode, new CString("height"), new CString(height), new CString(""));
            Entity leaf = this.dotStringFactory.getBibliotekon().getLeaf(node);
            this.nodes.put(leaf, agnode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        lock.lock();
        try {
            ImageData imageData = this.createFileLocked(os, dotStrings, fileFormatOption);
            return imageData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOneGraphic(UGraphic ug) {
        for (Entity leaf : this.diagram.getEntityFactory().leafs()) {
            this.printEntityNew(leaf);
        }
        Globals zz = Globals.open();
        try {
            TextBlock textBlock = this.getTextBlock(zz);
            textBlock.drawU(ug);
        }
        catch (Throwable e) {
            SmetanaDebug.printMe();
        }
        finally {
            Globals.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createFileLocked(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        for (Entity leaf : this.diagram.getEntityFactory().leafs()) {
            this.printEntityNew(leaf);
        }
        Globals zz = Globals.open();
        try {
            TextBlock drawable = this.getTextBlock(zz);
            ImageData imageData = this.diagram.createImageBuilder(fileFormatOption).drawable(drawable).write(os);
            return imageData;
        }
        catch (Throwable e) {
            SmetanaDebug.printMe();
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerSmetana.getFailureText3(e));
            ImageData imageData = ImageDataSimple.error();
            return imageData;
        }
        finally {
            Globals.close();
        }
    }

    private TextBlock getTextBlock(Globals zz) {
        ST_Agraph_s g = graph__c.agopen(zz, new CString("g"), zz.Agdirected, null);
        this.exportEntities(zz, g, this.getUnpackagedEntities());
        this.exportGroups(zz, g, this.diagram.getEntityFactory().getRootGroup());
        for (Link link : this.diagram.getLinks()) {
            ST_Agedge_s e = this.createEdge(zz, g, link);
            if (e == null) continue;
            this.edges.put(link, e);
        }
        ST_GVC_s gvc = gvc__c.gvContext(zz, new Object[0]);
        SmetanaDebug.reset();
        gvlayout__c.gvLayoutJobs(zz, gvc, g);
        SmetanaDebug.printMe();
        Drawing drawable = new Drawing();
        return drawable;
    }

    private void exportGroups(Globals zz, ST_Agraph_s graph, Entity parent) {
        for (Entity g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                this.exportEntity(zz, graph, g);
                continue;
            }
            this.exportGroup(zz, graph, g);
        }
    }

    private void exportGroup(Globals zz, ST_Agraph_s graph, Entity group) {
        Cluster cluster = this.getBibliotekon().getCluster(group);
        if (cluster == null) {
            System.err.println("CucaDiagramFileMakerJDot::exportGroup issue");
            return;
        }
        JUtils.LOG2("cluster = " + cluster.getClusterId());
        ST_Agraph_s cluster1 = subg__c.agsubg(zz, graph, new CString(cluster.getClusterId()), true);
        if (cluster.isLabel()) {
            double width = cluster.getTitleAndAttributeWidth();
            double height = cluster.getTitleAndAttributeHeight() - 5;
            attr__c.agsafeset(zz, cluster1, new CString("label"), Macro.createHackInitDimensionFromLabel((int)width, (int)height), new CString(""));
        }
        this.exportEntities(zz, cluster1, group.leafs());
        this.clusters.put(group, cluster1);
        this.exportGroups(zz, cluster1, group);
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.diagram.getUmlDiagramType().getStyleName(), SName.arrow).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
    }

    private TextBlock getLabel(Link link) {
        double marginLabel = 1.0;
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style style = this.getStyle();
        FontConfiguration labelFont = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        TextBlock label = link.getLabel().create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return label;
        }
        return TextBlockUtils.withMargin(label, 1.0, 1.0);
    }

    private TextBlock getQuantifier(Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQuantifier1() : link.getQuantifier2();
        if (tmp == null) {
            return null;
        }
        double marginLabel = 1.0;
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style style = this.getStyle();
        FontConfiguration labelFont = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        TextBlock label = Display.getWithNewlines(tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return label;
        }
        return TextBlockUtils.withMargin(label, 1.0, 1.0);
    }

    private ST_Agnode_s getAgnodeFromLeaf(Entity entity) {
        ST_Agnode_s n = this.nodes.get(entity);
        if (n != null) {
            return n;
        }
        try {
            String id = this.getBibliotekon().getNodeUid(entity);
            for (Map.Entry<Entity, ST_Agnode_s> ent : this.nodes.entrySet()) {
                if (!id.equals(this.getBibliotekon().getNodeUid(ent.getKey()))) continue;
                return ent.getValue();
            }
        }
        catch (IllegalStateException e) {
            System.err.println("UNKNOWN ENTITY");
        }
        return null;
    }

    private ST_Agedge_s createEdge(Globals zz, ST_Agraph_s g, Link link) {
        TextBlock q2;
        TextBlock q1;
        ST_Agnode_s n = this.getAgnodeFromLeaf(link.getEntity1());
        ST_Agnode_s m = this.getAgnodeFromLeaf(link.getEntity2());
        if (n == null) {
            return null;
        }
        if (m == null) {
            return null;
        }
        ST_Agedge_s e = edge__c.agedge(zz, g, n, m, null, true);
        attr__c.agsafeset(zz, e, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(zz, e, new CString("arrowhead"), new CString("none"), new CString(""));
        int length = link.getLength();
        attr__c.agsafeset(zz, e, new CString("minlen"), new CString("" + (length - 1)), new CString(""));
        TextBlock label = this.getLabel(link);
        if (!TextBlockUtils.isEmpty(label, this.stringBounder)) {
            XDimension2D dimLabel = label.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("label"), hackDim, new CString(""));
        }
        if ((q1 = this.getQuantifier(link, 1)) != null) {
            XDimension2D dimLabel = q1.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("taillabel"), hackDim, new CString(""));
        }
        if ((q2 = this.getQuantifier(link, 2)) != null) {
            XDimension2D dimLabel = q2.calculateDimension(this.stringBounder);
            CString hackDim = Macro.createHackInitDimensionFromLabel((int)dimLabel.getWidth(), (int)dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("headlabel"), hackDim, new CString(""));
        }
        return e;
    }

    private static List<String> getFailureText3(Throwable exception) {
        Logme.error(exception);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("Sorry, the subproject Smetana is not finished yet...");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        strings.add(" ");
        return strings;
    }

    private void printEntityNew(Entity ent) {
        if (ent.isRemoved()) {
            System.err.println("Jdot STRANGE: entity is removed");
            return;
        }
        IEntityImage image = this.printEntityInternal(ent);
        SvekNode shape = this.getBibliotekon().createNode(ent, image, this.dotStringFactory.getColorSequence(), this.stringBounder);
    }

    private Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    private IEntityImage printEntityInternal(Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getUmlDiagramType(), this.diagram.getLinks());
        }
        return ent.getSvekImage();
    }

    class Drawing
    extends AbstractTextBlock {
        private final YMirror ymirror;
        private final MinMaxMutable minMax;

        public Drawing() {
            this.minMax = CucaDiagramFileMakerSmetana.this.getSmetanaMinMax();
            this.ymirror = new YMirror(this.minMax.getMaxY() + 6.0);
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(6.0, 6.0 - this.minMax.getMinY()));
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.clusters.entrySet()) {
                CucaDiagramFileMakerSmetana.this.drawGroup(ug, this.ymirror, (Entity)ent.getKey(), (ST_Agraph_s)ent.getValue());
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.nodes.entrySet()) {
                Entity leaf = (Entity)ent.getKey();
                ST_Agnode_s agnode = (ST_Agnode_s)ent.getValue();
                XPoint2D corner = this.getCorner(agnode);
                SvekNode node = CucaDiagramFileMakerSmetana.this.dotStringFactory.getBibliotekon().getNode(leaf);
                IEntityImage image = node.getImage();
                image.drawU(ug.apply(new UTranslate(corner)));
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.edges.entrySet()) {
                Link link = (Link)ent.getKey();
                if (link.isInvis()) continue;
                ST_Agedge_s edge = (ST_Agedge_s)ent.getValue();
                new SmetanaPath(link, edge, this.ymirror, CucaDiagramFileMakerSmetana.this.diagram, CucaDiagramFileMakerSmetana.this.getLabel(link), CucaDiagramFileMakerSmetana.this.getQuantifier(link, 1), CucaDiagramFileMakerSmetana.this.getQuantifier(link, 2)).drawU(ug);
            }
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return this.minMax.getDimension().delta(6.0);
        }

        private XPoint2D getCorner(ST_Agnode_s n) {
            ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)n.data;
            double width = data.width * 72.0;
            double height = data.height * 72.0;
            double x = data.coord.x;
            double y = data.coord.y;
            return this.ymirror.getMirrored(new XPoint2D(x - width / 2.0, y + height / 2.0));
        }

        @Override
        public HColor getBackcolor() {
            return null;
        }
    }
}

