/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.AbstractShadowable;
import net.sourceforge.plantuml.klimt.UShapeSized;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class ULine
extends AbstractShadowable
implements UShapeSized {
    private final double dx;
    private final double dy;

    public ULine(XPoint2D p1, XPoint2D p2) {
        this(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public ULine(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public ULine rotate(double theta) {
        if (theta == 0.0) {
            return this;
        }
        AffineTransform rot = AffineTransform.getRotateInstance(theta);
        XPoint2D tmp = new XPoint2D(this.dx, this.dy).transform(rot);
        return new ULine(tmp.getX(), tmp.getY());
    }

    public static ULine hline(double dx) {
        return new ULine(dx, 0.0);
    }

    public static ULine vline(double dy) {
        return new ULine(0.0, dy);
    }

    public String toString() {
        return "ULine dx=" + this.dx + " dy=" + this.dy;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public double getLength() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    @Override
    public double getWidth() {
        return this.dx;
    }

    @Override
    public double getHeight() {
        return this.dy;
    }
}

