/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.PlacementStrategy;

public abstract class AbstractPlacementStrategy
implements PlacementStrategy {
    private final StringBounder stringBounder;
    private final Map<TextBlock, XDimension2D> dimensions = new LinkedHashMap<TextBlock, XDimension2D>();

    public AbstractPlacementStrategy(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    @Override
    public void add(TextBlock block) {
        this.dimensions.put(block, block.calculateDimension(this.stringBounder));
    }

    protected Map<TextBlock, XDimension2D> getDimensions() {
        return this.dimensions;
    }

    protected double getSumWidth() {
        return this.getSumWidth(this.dimensions.values().iterator());
    }

    protected double getSumHeight() {
        return this.getSumHeight(this.dimensions.values().iterator());
    }

    protected double getMaxHeight() {
        return this.getMaxHeight(this.dimensions.values().iterator());
    }

    protected double getMaxWidth() {
        return this.getMaxWidth(this.dimensions.values().iterator());
    }

    protected double getSumWidth(Iterator<XDimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result += it.next().getWidth();
        }
        return result;
    }

    protected double getSumHeight(Iterator<XDimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result += it.next().getHeight();
        }
        return result;
    }

    protected double getMaxWidth(Iterator<XDimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result = Math.max(result, it.next().getWidth());
        }
        return result;
    }

    protected double getMaxHeight(Iterator<XDimension2D> it) {
        double result = 0.0;
        while (it.hasNext()) {
            result = Math.max(result, it.next().getHeight());
        }
        return result;
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }
}

