/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class Player
implements TimeProjected {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    private final boolean compact;
    private final Display title;
    protected int suggestedHeight;
    protected final Stereotype stereotype;

    public Player(String title, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype) {
        this.stereotype = stereotype;
        this.skinParam = skinParam;
        this.compact = compact;
        this.ruler = ruler;
        this.title = Display.getWithNewlines(title);
    }

    public boolean isCompact() {
        return this.compact;
    }

    protected abstract StyleSignature getStyleSignature();

    protected final Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    protected final FontConfiguration getFontConfiguration() {
        return FontConfiguration.create(this.skinParam, StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
    }

    protected final UStroke getStroke() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.getStroke();
    }

    protected final SymbolContext getContext() {
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor lineColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        return new SymbolContext(backgroundColor, lineColor).withStroke(this.getStroke());
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void addNote(TimeTick var1, Display var2, Position var3);

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3, ArrowConfiguration var4);

    public abstract TextBlock getPart1(double var1, double var3);

    public abstract UDrawable getPart2();

    public abstract double getFullHeight(StringBounder var1);

    public final void setHeight(int height) {
        this.suggestedHeight = height;
    }
}

