/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.svek.PointListIterator;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.utils.Log;

class PointListIteratorImpl
implements PointListIterator {
    private final SvgResult svg;
    private int pos = 0;

    static PointListIterator create(SvgResult svg, int lineColor) {
        PointListIteratorImpl result = new PointListIteratorImpl(svg);
        int idx = svg.getIndexFromColor(lineColor);
        if (idx == -1) {
            result.pos = -1;
        }
        return result;
    }

    @Override
    public PointListIterator cloneMe() {
        PointListIteratorImpl result = new PointListIteratorImpl(this.svg);
        result.pos = this.pos;
        return result;
    }

    private PointListIteratorImpl(SvgResult svg) {
        this.svg = svg;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public List<XPoint2D> next() {
        if (this.pos == -1) {
            return Collections.emptyList();
        }
        try {
            List<XPoint2D> result = this.svg.substring(this.pos).extractList("points=\"");
            this.pos = this.svg.indexOf("points=\"", this.pos) + "points=\"".length() + 1;
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.error("Error " + e);
            return Collections.emptyList();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

