/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.EnumSet;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public enum PackageStyle {
    FOLDER,
    RECTANGLE,
    NODE,
    FRAME,
    CLOUD,
    DATABASE,
    AGENT,
    STORAGE,
    COMPONENT1,
    COMPONENT2,
    ARTIFACT,
    CARD;


    public static PackageStyle fromString(String value) {
        for (PackageStyle p : EnumSet.allOf(PackageStyle.class)) {
            if (!p.toString().equalsIgnoreCase(value)) continue;
            return p;
        }
        if ("rect".equalsIgnoreCase(value)) {
            return RECTANGLE;
        }
        return null;
    }

    public USymbol toUSymbol() {
        if (this == NODE) {
            return USymbols.NODE;
        }
        if (this == CARD) {
            return USymbols.CARD;
        }
        if (this == DATABASE) {
            return USymbols.DATABASE;
        }
        if (this == CLOUD) {
            return USymbols.CLOUD;
        }
        if (this == FRAME) {
            return USymbols.FRAME;
        }
        if (this == RECTANGLE) {
            return USymbols.RECTANGLE;
        }
        if (this == FOLDER) {
            return USymbols.PACKAGE;
        }
        return null;
    }

    public void drawU(UGraphic ug, XDimension2D dim, XDimension2D titleDim, boolean shadowing) {
        if (titleDim == null) {
            titleDim = new XDimension2D(0.0, 0.0);
        }
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (this == DATABASE) {
            this.drawDatabase(ug, width, height, shadowing);
        } else if (this == FOLDER) {
            this.drawFolder(ug, width, height, shadowing);
        } else if (this == FRAME) {
            this.drawFrame(ug, width, height, titleDim, shadowing);
        } else if (this == CLOUD) {
            this.drawCloud(ug, width, height, shadowing);
        } else if (this == RECTANGLE) {
            this.drawRect(ug, width, height, shadowing);
        } else if (this == COMPONENT1) {
            this.drawComponent1(ug, width, height, shadowing);
        } else if (this == COMPONENT2) {
            this.drawComponent2(ug, width, height, shadowing);
        } else if (this == STORAGE) {
            this.drawStorage(ug, width, height, shadowing);
        } else if (this == AGENT) {
            this.drawRect(ug, width, height, shadowing);
        } else if (this == ARTIFACT) {
            this.drawArtifact(ug, width, height, shadowing);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void drawArtifact(UGraphic ug, double width, double height, boolean shadowing) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, height);
        polygon.addPoint(width, height);
        int cornersize = 10;
        polygon.addPoint(width, 10.0);
        polygon.addPoint(width - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        if (shadowing) {
            polygon.setDeltaShadow(3.0);
        }
        ug.draw(polygon);
        ug.apply(UTranslate.dx(width - 10.0)).draw(ULine.vline(10.0));
        ug.apply(new UTranslate(width, 10.0)).draw(ULine.hline(-10.0));
    }

    private void drawStorage(UGraphic ug, double width, double height, boolean shadowing) {
        URectangle shape = new URectangle(width, height).rounded(70.0);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
    }

    private void drawComponent1(UGraphic ug, double widthTotal, double heightTotal, boolean shadowing) {
        URectangle form = new URectangle(widthTotal, heightTotal);
        if (shadowing) {
            form.setDeltaShadow(4.0);
        }
        URectangle small = new URectangle(10.0, 5.0);
        ug.draw(form);
        ug.apply(new UTranslate(-5.0, 5.0)).draw(small);
        ug.apply(new UTranslate(-5.0, heightTotal - 10.0)).draw(small);
    }

    private void drawComponent2(UGraphic ug, double widthTotal, double heightTotal, boolean shadowing) {
        URectangle form = new URectangle(widthTotal, heightTotal);
        if (shadowing) {
            form.setDeltaShadow(4.0);
        }
        URectangle small = new URectangle(15.0, 10.0);
        URectangle tiny = new URectangle(4.0, 2.0);
        ug.draw(form);
        ug.apply(new UTranslate(widthTotal - 20.0, 5.0)).draw(small);
        ug.apply(new UTranslate(widthTotal - 22.0, 7.0)).draw(tiny);
        ug.apply(new UTranslate(widthTotal - 22.0, 11.0)).draw(tiny);
    }

    private void drawRect(UGraphic ug, double width, double height, boolean shadowing) {
        URectangle shape = new URectangle(width, height);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
    }

    private void drawCloud(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = this.getSpecificFrontierForCloud(width, height);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.apply(new UTranslate(3.0, -3.0)).draw(shape);
    }

    private UPath getSpecificFrontierForCloud(double width, double height) {
        UPath path = new UPath();
        path.moveTo(0.0, 10.0);
        double x = 0.0;
        int i = 0;
        while ((double)i < width - 9.0) {
            path.cubicTo(i, 7.0, 2 + i, 5.0, 5 + i, 5.0);
            path.cubicTo(8 + i, 5.0, 10 + i, 7.0, 10 + i, 10.0);
            x = i + 10;
            i += 10;
        }
        double y = 0.0;
        int j = 10;
        while ((double)j < height - 9.0) {
            path.cubicTo(x + 3.0, j, x + 5.0, 2 + j, x + 5.0, 5 + j);
            path.cubicTo(x + 5.0, 8 + j, x + 3.0, 10 + j, x, 10 + j);
            y = j + 10;
            j += 10;
        }
        int i2 = 0;
        while ((double)i2 < width - 9.0) {
            path.cubicTo(x - (double)i2, y + 3.0, x - 3.0 - (double)i2, y + 5.0, x - 5.0 - (double)i2, y + 5.0);
            path.cubicTo(x - 8.0 - (double)i2, y + 5.0, x - 10.0 - (double)i2, y + 3.0, x - 10.0 - (double)i2, y);
            i2 += 10;
        }
        j = 0;
        while ((double)j < height - 9.0 - 10.0) {
            path.cubicTo(-3.0, y - (double)j, -5.0, y - 2.0 - (double)j, -5.0, y - 5.0 - (double)j);
            path.cubicTo(-5.0, y - 8.0 - (double)j, -3.0, y - 10.0 - (double)j, 0.0, y - 10.0 - (double)j);
            j += 10;
        }
        return path;
    }

    private void drawFrame(UGraphic ug, double width, double height, XDimension2D dimTitle, boolean shadowing) {
        int cornersize;
        double textHeight;
        double textWidth;
        URectangle shape = new URectangle(width, height);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
        if (dimTitle.getWidth() == 0.0) {
            textWidth = width / 3.0;
            textHeight = 12.0;
            cornersize = 7;
        } else {
            textWidth = dimTitle.getWidth() + 10.0;
            textHeight = dimTitle.getHeight() + 3.0;
            cornersize = 10;
        }
        UPath polygon = new UPath();
        polygon.moveTo(textWidth, 1.0);
        polygon.lineTo(textWidth, textHeight - (double)cornersize);
        polygon.lineTo(textWidth - (double)cornersize, textHeight);
        polygon.lineTo(0.0, textHeight);
        ug.draw(polygon);
    }

    private void drawFolder(UGraphic ug, double width, double height, boolean shadowing) {
        double wtitle = Math.max(30.0, width / 4.0);
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 0.0);
        shape.addPoint(wtitle, 0.0);
        double htitle = 10.0;
        double marginTitleX3 = 7.0;
        shape.addPoint(wtitle + 7.0, 10.0);
        shape.addPoint(width, 10.0);
        shape.addPoint(width, height);
        shape.addPoint(0.0, height);
        shape.addPoint(0.0, 0.0);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
        ug.apply(UTranslate.dy(10.0)).draw(ULine.hline(wtitle + 7.0));
    }

    private void drawDatabase(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = new UPath();
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        shape.moveTo(0.0, 10.0);
        shape.cubicTo(10.0, 0.0, width / 2.0 - 10.0, 0.0, width / 2.0, 0.0);
        shape.cubicTo(width / 2.0 + 10.0, 0.0, width - 10.0, 0.0, width, 10.0);
        shape.lineTo(width, height - 10.0);
        shape.cubicTo(width - 10.0, height, width / 2.0 - 10.0, height, width / 2.0, height);
        shape.cubicTo(width / 2.0 + 10.0, height, 10.0, height, 0.0, height - 10.0);
        shape.lineTo(0.0, 10.0);
        ug.draw(shape);
        UPath closing = new UPath();
        closing.moveTo(0.0, 10.0);
        closing.cubicTo(10.0, 20.0, width / 2.0 - 10.0, 20.0, width / 2.0, 20.0);
        closing.cubicTo(width / 2.0 + 10.0, 20.0, width - 10.0, 20.0, width, 10.0);
        ug.draw(closing);
    }

    private void drawNode(UGraphic ug, double xTheoricalPosition, double yTheoricalPosition, double width, double height, boolean shadowing) {
        UPolygon shape = new UPolygon();
        shape.addPoint(0.0, 10.0);
        shape.addPoint(10.0, 0.0);
        shape.addPoint(width, 0.0);
        shape.addPoint(width, height - 10.0);
        shape.addPoint(width - 10.0, height);
        shape.addPoint(0.0, height);
        shape.addPoint(0.0, 10.0);
        if (shadowing) {
            shape.setDeltaShadow(2.0);
        }
        ug.apply(new UTranslate(xTheoricalPosition, yTheoricalPosition)).draw(shape);
        ug.apply(new UTranslate(xTheoricalPosition + width - 10.0, yTheoricalPosition + 10.0)).draw(new ULine(9.0, -9.0));
        UPath path = new UPath();
        path.moveTo(0.0, 0.0);
        path.lineTo(width - 10.0, 0.0);
        path.lineTo(width - 10.0, height - 10.0);
        ug.apply(new UTranslate(xTheoricalPosition, yTheoricalPosition + 10.0)).draw(path);
    }
}

