/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.Collections;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ebnf.PSystemEbnf;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.StringLocated;

public class CommandEBnfSingleLine
extends SingleLineCommand2<PSystemEbnf> {
    public CommandEBnfSingleLine() {
        super(true, CommandEBnfSingleLine.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandEBnfSingleLine.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(\\*"), new RegexLeaf("COMMENTA", "(.*[^%s].*)"), new RegexLeaf("\\*\\)"), RegexLeaf.spaceZeroOrMore())), new RegexLeaf("ID", "(\\w[-\\w]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(\\*"), new RegexLeaf("COMMENTB", "(.*[^%s].*)"), new RegexLeaf("\\*\\)"), RegexLeaf.spaceZeroOrMore())), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("EQUALS", "(=)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LINE", "(.*;)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(PSystemEbnf diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String id = arg.get("ID", 0);
        String equals = arg.get("EQUALS", 0);
        String line = arg.get("LINE", 0);
        String full = id + equals + line;
        String commentAbove = arg.get("COMMENTA", 0);
        String commentBelow = arg.get("COMMENTB", 0);
        StringLocated string = new StringLocated(full, location);
        return diagram.addBlocLines(BlocLines.from(Collections.singletonList(string)), commentAbove, commentBelow);
    }
}

