/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.GroupPngMakerActivity;
import net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierActivity {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierActivity(ICucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            ArrayList<IGroup> groups = new ArrayList<IGroup>(diagram.getGroups(false));
            for (IGroup g : groups) {
                if (!diagram.isAutarkic(g)) continue;
                IEntityImage img = this.computeImage(g);
                g.overrideImage(img, LeafType.ACTIVITY);
                changed = true;
            }
        } while (changed);
    }

    private IEntityImage computeImage(IGroup g) throws IOException, InterruptedException {
        GroupPngMakerActivity maker = new GroupPngMakerActivity(this.diagram, g, this.stringBounder);
        return maker.getImage();
    }
}

