/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class LinkArg {
    private final Display label;
    private final String quantifier1;
    private final String quantifier2;
    private final String labeldistance;
    private final String labelangle;
    private final String kal1;
    private final String kal2;
    private VisibilityModifier visibilityModifier;
    private int length;

    public static LinkArg build(Display label, int length) {
        return LinkArg.build(label, length, true);
    }

    public static LinkArg noDisplay(int length) {
        return LinkArg.build(Display.NULL, length, true);
    }

    public static LinkArg build(Display label, int length, boolean manageVisibilityModifier) {
        Display newLabel;
        VisibilityModifier visibilityModifier = null;
        if (Display.isNull(label)) {
            newLabel = Display.NULL;
        } else {
            newLabel = label.manageGuillemet(manageVisibilityModifier);
            if (manageVisibilityModifier && VisibilityModifier.isVisibilityCharacter(label.get(0))) {
                visibilityModifier = VisibilityModifier.getVisibilityModifier(label.get(0), false);
            }
        }
        return new LinkArg(newLabel, length, null, null, null, null, visibilityModifier, null, null);
    }

    public LinkArg withQuantifier(String quantifier1, String quantifier2) {
        return new LinkArg(this.label, this.length, quantifier1, quantifier2, this.labeldistance, this.labelangle, this.visibilityModifier, this.kal1, this.kal2);
    }

    public LinkArg withKal(String kal1, String kal2) {
        return new LinkArg(this.label, this.length, this.quantifier1, this.quantifier2, this.labeldistance, this.labelangle, this.visibilityModifier, kal1, kal2);
    }

    public LinkArg withDistanceAngle(String labeldistance, String labelangle) {
        return new LinkArg(this.label, this.length, this.quantifier1, this.quantifier2, labeldistance, labelangle, this.visibilityModifier, this.kal1, this.kal2);
    }

    private LinkArg(Display label, int length, String quantifier1, String quantifier2, String labeldistance, String labelangle, VisibilityModifier visibilityModifier, String kal1, String kal2) {
        this.label = label;
        this.visibilityModifier = visibilityModifier;
        this.length = length;
        this.quantifier1 = quantifier1;
        this.quantifier2 = quantifier2;
        this.labeldistance = labeldistance;
        this.labelangle = labelangle;
        this.kal1 = kal1;
        this.kal2 = kal2;
    }

    public LinkArg getInv() {
        return new LinkArg(this.label, this.length, this.quantifier2, this.quantifier1, this.labeldistance, this.labelangle, this.visibilityModifier, this.kal1, this.kal2);
    }

    public final Display getLabel() {
        return this.label;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getQuantifier1() {
        return this.quantifier1;
    }

    public final String getQuantifier2() {
        return this.quantifier2;
    }

    public final String getLabeldistance() {
        return this.labeldistance;
    }

    public final String getLabelangle() {
        return this.labelangle;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public final void setVisibilityModifier(VisibilityModifier visibilityModifier) {
        this.visibilityModifier = visibilityModifier;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final String getKal1() {
        return this.kal1;
    }

    public final String getKal2() {
        return this.kal2;
    }
}

