/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.compositediagram.command;

import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandLinkBlock
extends SingleLineCommand2<CompositeDiagram> {
    public CommandLinkBlock() {
        super(CommandLinkBlock.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkBlock.class.getName(), RegexLeaf.start(), new RegexLeaf("ENT1", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DECO1", "(\\[\\]|\\*\\))?"), new RegexLeaf("QUEUE", "([=-]+|\\.+)"), new RegexLeaf("DECO2", "(\\[\\]|\\(\\*)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ENT2", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY", "(\\S*+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, LineLocation location, RegexResult arg) {
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        IEntity cl1 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(ent1), diagram.buildCode(ent1), null, null);
        IEntity cl2 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(ent2), diagram.buildCode(ent2), null, null);
        String deco1 = arg.get("DECO1", 0);
        String deco2 = arg.get("DECO2", 0);
        LinkType linkType = new LinkType(this.getLinkDecor(deco1), this.getLinkDecor(deco2));
        String queue = arg.get("QUEUE", 0);
        LinkArg linkArg = LinkArg.build(Display.getWithNewlines(arg.get("DISPLAY", 0)), queue.length(), diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg);
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkDecor getLinkDecor(String s) {
        if ("[]".equals(s)) {
            return LinkDecor.SQUARE_toberemoved;
        }
        return LinkDecor.NONE;
    }
}

