/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.BigFrame;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class AnnotatedBuilder {
    private final Annotated annotated;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;

    public AnnotatedBuilder(Annotated annotated, ISkinParam skinParam, StringBounder stringBounder) {
        this.annotated = annotated;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
    }

    public boolean hasMainFrame() {
        return this.annotated.getMainFrame() != null;
    }

    public double mainFrameSuppHeight() {
        Display mainFrame = this.annotated.getMainFrame();
        Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.mainframe).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = FontConfiguration.create(this.getSkinParam(), style);
        TextBlock title = mainFrame.create(fontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam());
        XDimension2D dimTitle = title.calculateDimension(this.stringBounder);
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding().incTop(dimTitle.getHeight() + 10.0);
        return margin.getBottom() + margin.getTop() + padding.getTop() + padding.getBottom() + 10.0;
    }

    public TextBlock decoreWithFrame(final TextBlock original) {
        Display mainFrame = this.annotated.getMainFrame();
        if (mainFrame == null) {
            return original;
        }
        Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.mainframe).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = FontConfiguration.create(this.getSkinParam(), style);
        TextBlock title = mainFrame.create(fontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam());
        final XDimension2D dimTitle = title.calculateDimension(this.stringBounder);
        final SymbolContext symbolContext = style.getSymbolContext(this.skinParam.getIHtmlColorSet());
        final ClockwiseTopRightBottomLeft margin = style.getMargin();
        final ClockwiseTopRightBottomLeft padding = style.getPadding().incTop(dimTitle.getHeight() + 10.0);
        MinMax originalMinMax = TextBlockUtils.getMinMax(original, this.stringBounder, false);
        double ww = originalMinMax.getMinX() >= 0.0 ? originalMinMax.getMaxX() : originalMinMax.getWidth();
        double hh = originalMinMax.getMinY() >= 0.0 ? originalMinMax.getMaxY() : originalMinMax.getHeight();
        final double dx = originalMinMax.getMinX() < 0.0 ? -originalMinMax.getMinX() : 0.0;
        final double dy = originalMinMax.getMinY() < 0.0 ? -originalMinMax.getMinY() : 0.0;
        final UTranslate delta = new UTranslate(dx, dy);
        double width = padding.getLeft() + Math.max(ww + 12.0, dimTitle.getWidth() + 10.0) + padding.getRight();
        double height = padding.getTop() + dimTitle.getHeight() + hh + padding.getBottom();
        final BigFrame frame = new BigFrame(title, width, height, symbolContext);
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                frame.drawU(ug.apply(margin.getTranslate()));
                original.drawU(ug.apply(margin.getTranslate().compose(padding.getTranslate().compose(delta))));
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                XRectangle2D rect = original.getInnerPosition(member, stringBounder, strategy);
                return new XRectangle2D(dx + rect.getX() + margin.getLeft() + padding.getLeft(), dy + rect.getY() + margin.getTop() + padding.getTop() + dimTitle.getHeight(), rect.getWidth(), rect.getHeight());
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dim1 = original.calculateDimension(stringBounder);
                XDimension2D dim2 = padding.apply(dim1);
                XDimension2D dim3 = margin.apply(dim2);
                return dim3;
            }

            @Override
            public HColor getBackcolor() {
                return symbolContext.getBackColor();
            }
        };
    }

    private ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public TextBlock getLegend() {
        DisplayPositioned legend = this.annotated.getLegend();
        return EntityImageLegend.create(legend.getDisplay(), this.getSkinParam());
    }

    public TextBlock getTitle() {
        DisplayPositioned title = (DisplayPositioned)this.annotated.getTitle();
        Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.title).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        TextBlock block = style.createTextBlockBordered(title.getDisplay(), this.skinParam.getIHtmlColorSet(), this.skinParam, "_title");
        return block;
    }

    public TextBlock getCaption() {
        DisplayPositioned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.caption).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style.createTextBlockBordered(caption.getDisplay(), this.skinParam.getIHtmlColorSet(), this.skinParam, "_caption");
    }

    public TextBlock addHeaderAndFooter(TextBlock original) {
        DisplaySection footer = this.annotated.getFooter();
        DisplaySection header = this.annotated.getHeader();
        if (footer.isNull() && header.isNull()) {
            return original;
        }
        TextBlock textFooter = null;
        if (!footer.isNull()) {
            Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.footer).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            textFooter = footer.createRibbon(FontConfiguration.create(this.getSkinParam(), FontParam.FOOTER, null), this.getSkinParam(), style);
        }
        TextBlock textHeader = null;
        if (!header.isNull()) {
            Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.header).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            textHeader = header.createRibbon(FontConfiguration.create(this.getSkinParam(), FontParam.HEADER, null), this.getSkinParam(), style);
        }
        return DecorateEntityImage.addTopAndBottom(original, textHeader, header.getHorizontalAlignment(), textFooter, footer.getHorizontalAlignment());
    }
}

