/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.telnet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.log.Logme;

class AcceptTelnetClient
extends Thread {
    private final Socket clientSocket;
    private final BufferedReader br;
    private final OutputStream os;

    AcceptTelnetClient(Socket socket) throws Exception {
        this.clientSocket = socket;
        System.out.println("Client Connected ...");
        this.br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.os = this.clientSocket.getOutputStream();
        this.start();
    }

    public String runInternal() throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        do {
            if ((s = this.br.readLine()) == null) {
                return sb.toString();
            }
            Log.println("S=" + s);
            sb.append(s);
            sb.append('\n');
        } while (!s.equalsIgnoreCase("@enduml"));
        return sb.toString();
    }

    @Override
    public void run() {
        try {
            String uml = this.runInternal();
            Log.println("UML=" + uml);
            SourceStringReader s = new SourceStringReader(uml);
            s.outputImage(this.os, new FileFormatOption(FileFormat.ATXT));
            this.os.close();
            this.br.close();
        }
        catch (IOException e) {
            Logme.error(e);
        }
    }
}

