/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.security.SFile;

public class SvekUtils {
    public static void traceString(SFile f, String text) throws IOException {
        Log.info("Creating intermediate file " + f.getPrintablePath());
        try (PrintWriter pw = f.createPrintWriter();){
            pw.print(text);
        }
    }

    public static double getValue(String svg, int starting, String varName) {
        String varNameString = varName + "=\"";
        int p1 = svg.indexOf(varNameString, starting);
        if (p1 == -1) {
            throw new IllegalStateException();
        }
        int p2 = svg.indexOf(34, p1 += varNameString.length());
        return Double.parseDouble(svg.substring(p1, p2));
    }

    public static XPoint2D getMinXY(List<XPoint2D> points) {
        double minx = points.get((int)0).x;
        double miny = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (points.get((int)i).x < minx) {
                minx = points.get((int)i).x;
            }
            if (!(points.get((int)i).y < miny)) continue;
            miny = points.get((int)i).y;
        }
        return new XPoint2D(minx, miny);
    }

    public static XPoint2D getMaxXY(List<XPoint2D> points) {
        double maxx = points.get((int)0).x;
        double maxy = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (points.get((int)i).x > maxx) {
                maxx = points.get((int)i).x;
            }
            if (!(points.get((int)i).y > maxy)) continue;
            maxy = points.get((int)i).y;
        }
        return new XPoint2D(maxx, maxy);
    }

    public static void println(StringBuilder sb) {
        sb.append('\n');
    }

    public static String pixelToInches(double pixel) {
        double v = pixel / 72.0;
        return String.format(Locale.US, "%6.6f", v);
    }
}

