/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.ebnf.PSystemEbnf;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandNoteMultilines
extends CommandMultilines2<PSystemEbnf> {
    public CommandNoteMultilines() {
        super(CommandNoteMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceZeroOrMore(), CommandNoteMultilines.color().getRegex(), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?note$";
    }

    @Override
    protected CommandExecutionResult executeNow(PSystemEbnf diagram, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display note = lines.toDisplay();
        Colors colors = CommandNoteMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        return diagram.addNote(note, colors);
    }
}

