/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.anim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.ugraphic.MinMax;

public class Animation {
    private final List<AffineTransformation> all;

    private Animation(List<AffineTransformation> all) {
        if (all.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.all = all;
    }

    public static Animation singleton(AffineTransformation affineTransformation) {
        if (affineTransformation == null) {
            return null;
        }
        return new Animation(Collections.singletonList(affineTransformation));
    }

    public static Animation create(List<String> descriptions) {
        ArrayList<AffineTransformation> all = new ArrayList<AffineTransformation>();
        for (String s : descriptions) {
            AffineTransformation tmp = AffineTransformation.create(s);
            if (tmp == null) continue;
            all.add(tmp);
        }
        return new Animation(all);
    }

    public Collection<AffineTransformation> getAll() {
        return Collections.unmodifiableCollection(this.all);
    }

    public void setDimension(XDimension2D dim) {
        for (AffineTransformation affineTransform : this.all) {
            affineTransform.setDimension(dim);
        }
    }

    public AffineTransformation getFirst() {
        return this.all.get(0);
    }

    public MinMax getMinMax(XDimension2D dim) {
        MinMax result = MinMax.getEmpty(false);
        for (AffineTransformation affineTransform : this.all) {
            MinMax m = affineTransform.getMinMax(dim);
            result = result.addMinMax(m);
        }
        return result;
    }
}

