/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileColumns;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileSplit
extends GtileColumns {
    private final HColor lineColor;

    public GtileSplit(List<Gtile> gtiles, Swimlane singleSwimlane, HColor lineColor) {
        super(gtiles, singleSwimlane, 20.0);
        this.lineColor = lineColor;
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionActivity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static final StyleSignatureBasic getDefaultStyleDefinitionDiamond() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        super.drawUInternal(ug);
        double x0 = ((Gtile)this.gtiles.get(0)).getCoord("NORTH_HOOK").compose(this.getPosition(0)).getDx();
        int last = this.gtiles.size() - 1;
        double xLast = ((Gtile)this.gtiles.get(last)).getCoord("NORTH_HOOK").compose(this.getPosition(last)).getDx();
        ULine hline = ULine.hline(xLast - x0);
        ug = ug.apply(this.lineColor).apply(new UStroke(1.5));
        ug.apply(UTranslate.dx(x0)).draw(hline);
        double y = this.getCoord("SOUTH_BORDER").getDy();
        ug.apply(new UTranslate(x0, y)).draw(hline);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return super.calculateDimension(stringBounder).delta(0.0, 0.0);
    }
}

