name = "pigeon"
age = 42
friends = new Listing {
  "barn owl"
  "parrot"
}
moreFriends = new {
  "elf owl"
  "eagle"
}
couple = Pair(name, friends[1])
hobbies {
  ["surfing"] {
    skill = "low"
  }
  ["firemaking"] {
    skill = "high"
  }
}
classification {
  ["red wolf"] {
    description = "confidential"
  }
  ["pink panther"] {
    description = "top secret"
  }
}
address {
  street = "Norton St."
  zip = 12345
}

output {
  renderer = new PropertiesRenderer {
    converters {
      ["name"] = (it) -> it.reverse()
      ["hobbies[*]"] = (it) -> it.skill
      ["address.street"] = (_) -> "Other St."
      ["address.*"] = (_) -> "changed"
      ["classification[pink panther]"] = (_) -> "official"
      ["classification[*]"] = (it) -> it.description
      ["unmatched"] = (_) -> "unmatched"
      [Listing] = (it) -> jsonRenderer.renderValue(it)
      [Pair] = (it) -> jsonRenderer.renderValue(List(it.first, it.second))
    }
    local jsonRenderer = new JsonRenderer {
      indent = ""
      converters {
        ["[*]"] = (it) -> it + "x"
      }
    }
  }
}
