amends ".../snippetTest.pkl"

import "@birds/catalog/Ostritch.pkl"
import "@birds/catalog/Swallow.pkl"

examples {
  ["import package"] {
    Ostritch
    Swallow
  }

  ["import module that uses triple-dot import"] {
    import("@birds/some/dir/Bird.pkl")
  }

  ["reading directories"] {
    read("@birds/catalog")
    // Omitting a slash is the package root
    read("@birds")
  }
}

facts {
  ["package-relative dependency is not same import as absolute URI dependency"] {
    import("@birds/Bird.pkl") != import("package://localhost:12110/birds@0.5.0#/Bird.pkl")
  }
  ["package-relative dependency has scheme projectpackage"] {
    import("@birds/Bird.pkl") == import("projectpackage://localhost:12110/birds@0.5.0#/Bird.pkl")
  }
  ["transitive import resolves to same dependency as direct dependency import"] {
    Swallow.favoriteFruit == import("@fruits/catalog/apple.pkl")
  }
  ["transitive import resolves to same dependency as projectpackage import"] {
    Swallow.favoriteFruit == import("projectpackage://localhost:12110/fruit@1.1.0#/catalog/apple.pkl")
    Swallow.favoriteFruit != import("projectpackage://localhost:12110/fruit@1.0.5#/catalog/apple.pkl")
  }
}
