import "pkl:test"

local x1: Mapping<String, List<Int>> = new {
  ["pigeon"] = List(1, 2, 3)
  ["barn owl"] = 42
}

local x2: Mapping<String, List<Int>> = new {
  ["fr" + "ed"] = List(1) + List(2, 3)
  ["bar" + "ney"] = 21 + 21
}

local x3: Mapping<List<Int>, String> = new {
  [List(1, 2, 3)] = "pigeon"
  [42] = "barn owl"
}

local x4: Mapping<List<Int>, String> = new {
  [List(1) + List(2, 3)] = "fr" + "ed"
  [21 + 21] = "bar" + "ney"
}

local x5: Mapping<String(!isEmpty), String> = new {
  [""] = "pigeon"
}
local x6: Mapping<String, String(!isEmpty)> = new {
  ["pigeon"] = ""
}

res1 = test.catch(() -> x1)
res2 = test.catch(() -> x2)
res3 = test.catch(() -> x3)
res4 = test.catch(() -> x4)
res5 = test.catch(() -> x5)
res6 = test.catch(() -> x6)

hidden x7: Mapping = new {
  ["first"] = throw("value unnecessarily evaluated")
}

hidden x8: Mapping<String, Any> = new {
  ["first"] = throw("value unnecessarily evaluated")
}

hidden x9: Mapping<String, unknown> = new {
  ["first"] = throw("value unnecessarily evaluated")
}

hidden x10 = new Mapping {
  ["first"] = throw("value unnecessarily evaluated")
  ["second"] = 42
  ["third"] = throw("value unnecessarily evaluated")
}

res7 = !x7.isEmpty
res8 = !x8.isEmpty
res9 = !x9.isEmpty
res10 = x10["second"] == 42
