amends ".../snippetTest.pkl"

import* "../../input-helper/globtest/*.pkl" as globTestFiles
import* "../../input-helper/globtest/*.pkl"

examples {
  ["import* clause keys"] {
    globTestFiles.keys.toListing()
  }

  ["import* inferred name"] {
    `*`.keys.toListing()
  }

  ["globstar"] {
    import*("../../input-helper/globtest/**.pkl").keys.toListing()
  }

  ["globstar then up one level"] {
    import*("../../input-helper/globtest/**/../*.pkl").keys.toListing()
  }

  ["empty glob matches current directory"] {
    import*("").keys.toListing()
    module.catch(() -> import*("").toMap())
  }

  ["no wildcards"] {
    import*("../../input-helper/globtest/moduleA.pkl").keys.toListing()
  }

  ["wildcard that does match"] {
    import*("../../input-helper/globtest/{moduleA}.pkl").keys.toListing()
  }

  ["character classes"] {
    import*("../../input-helper/globtest/module[A-B].pkl").keys.toListing()
  }

  ["match directories"] {
    module.catch(() -> import*("../../input-helper/globtest").toMap())
  }

  ["match literal backslash"] {
    import*("../../input-helper/globtest/\\\\moduleC.pkl").keys.toListing()
  }

  ["import glob first segment is wildcard"] {
    import*("*Glob.pkl").keys.toListing()
  }

  ["import glob matching unsafe uri chars"] {
    // no percent encoding because this is just a path (same rules as `import`)
    import*(#"../../input-helper/globtest/module with \[weird] ~!characters.pkl"#)
    import*("../../input-helper/globtest/module *")
  }

  ["package"] {
    import*("package://localhost:12110/birds@0.5.0#/catalog/*.pkl")
    import*("package://localhost:12110/birds@0.5.0#/**.pkl").keys.toListing()
  }

  ["globbing with absolute URIs and percent encoding"] {
    import*("package://localhost:12110/packageContainingWildcardCharacters@1.0.0#/name%20*")
    import*("package://localhost:12110/packageContainingWildcardCharacters@1.0.0#/name%20with%20%5C%5Bwildcard%5D!%20characters~~.pkl")
  }

  ["package glob and up one level"] {
    import*("package://localhost:12110/birds@0.5.0#/catalog/../catalog/*.pkl")
  }
}
