amends "../snippetTest.pkl"

import "pkl:math"

facts {
  ["pow"] {
    2.0 ** 3.0 ** 4.0 == 2.0 ** (3.0 ** 4.0)
    1.0 + 2.0 ** 3.0 == 1.0 + (2.0 ** 3.0)
    2.0 * 2.0 ** 3.0 == 2.0 * (2.0 ** 3.0)
    2.0 ** 3.0 + 1.0 == (2.0 ** 3.0) + 1.0
    2.0 ** 3.0 * 2.0 == (2.0 ** 3.0) * 2.0
  }

  ["equality"] {
    1.2 == 1.2
    1.0 == 1
    1 == 1.0
    !(1.2 == 1.3)
    !(1.2 == 1)
  }

  ["inequality"] {
    1.2 != 1.3
    1.2 != 1
    !(1.0 != 1)
    !(1.2 != 1.2)
    !(1 != 1.0)
  }

  ["greater than"] {
    1.3 > 1.2
    !(1.2 > 1.2)
    !(1.2 > 1.3)
  }

  ["less than"] {
    1.2 < 1.3
    !(1.2 < 1.2)
    !(1.3 < 1.2)
  }

  ["greater than or equal"] {
    1.2 >= 1.2
    1.3 >= 1.2
    !(1.2 >= 1.3)
  }

  ["less than or equal"] {
    1.2 <= 1.2
    1.2 <= 1.3
    !(1.3 <= 1.2)
  }

  ["underscores"] {
    123_456_789.123_456_789 == 123456789.123456789
    1____.1____ == 1.1
    1____1.1____1 == 11.11

    123.4_56e7 == 123.456e7
    123.4_56e-7 == 123.456e-7

    123.456e1_0 == 123.456e10
    1_23.456e-1_0 == 123.456e-10
  }
}

examples {
  ["literal"] {
    123456789.123456789
    123.456e7
    123.456e-7

    -123456789.123456789
    -123.456e7
    -123.456e-7

    4.9E-324
    1.7976931348623157E308

    123_456_789.123_456_789
    1____.1____
    1____1.1____1

    123.4_56e7
    123.4_56e-7

    123.456e1_0
    1_23.456e-1_0
  }

  ["addition"] {
    1.1 + 2.2
    1 + 2.2
  }

  ["subtraction"] {
    2.2 - 3.3
    2.2 - 3
  }

  ["multiplication"] {
    3.3 * 4.4
    3 * 4.4
  }

  ["division"] {
    4.4 / 5.5
    4.4 / 5
  }

  ["integer division"] {
    5 ~/ 3
    5.0 ~/ 3
    5 ~/ 3.0
    5.0 ~/ 3.0
    5.1 ~/ 3.1
  }

  ["remainder"] {
    5.5 % 6.5
    5 % 6.5
  }

  ["negation"] {
    // pkl, js, dart, and kotlin use #1; their grammar has no negative numeric literals
    // ruby and scala use #2 (scala switched from #1 around 2.8)
    //
    // 1.
    // local x = 1.2
    // -1.2.abs == -(1.2.abs)
    // -x.abs == -(x.abs)
    //
    // 2.
    // local x = 1.2
    // -1.2.abs == (-1.2).abs
    // -x.abs == -(x.abs)
    //
    // #1 is more intuitive for negative numeric literals, but less consistent

    local x = 1.2

    -1.2.abs
    -x.abs
  }

  ["power"] {
    2.3 ** 4.0
    2.3 ** 0.0
    2.3 ** -4.0

    0.0 ** 0.0
    1.0 ** 0.0
    -1.0 ** 0.0

    0.0 ** 1.0
    1.0 ** 1.0
    -1.0 ** 1.0

    0.0 ** -1.0
    1.0 ** -1.0
    -1.0 ** -1.0

    0.0 ** 42.0
    1.0 ** 42.0
    -1.0 ** 42.0

    0.0 ** -42.0
    1.0 ** -42.0
    -1.0 ** -42.0

    0.0 ** math.maxFiniteFloat
    1.0 ** math.maxFiniteFloat
    -1.0 ** math.maxFiniteFloat

    0.0 ** math.minFiniteFloat
    1.0 ** math.minFiniteFloat
    -1.0 ** math.minFiniteFloat

    2.0 ** math.maxInt8
    2.0 ** math.maxInt16
    2.0 ** math.maxInt32
    2.0 ** math.maxInt
    2.0 ** math.maxFiniteFloat
    -2.0 ** math.maxInt8
    -2.0 ** math.maxInt16
    -2.0 ** math.maxInt32
    -2.0 ** math.maxInt
    -2.0 ** math.maxFiniteFloat

    math.maxFiniteFloat ** 0.0
    math.maxFiniteFloat ** 1.0
    math.maxFiniteFloat ** 2.0
  }
}
