amends "../snippetTest.pkl"

local list1 = List(1, 2, 3)

examples {
  ["getOrNull()"] {
    list1.getOrNull(1)
    list1.getOrNull(3)
    list1.getOrNull(-1)
  }

  ["sublistOrNull()"] {
    list1.sublistOrNull(1, 3)
    list1.sublistOrNull(2, 4)
  }

  ["firstOrNull"] {
    list1.firstOrNull
    List().firstOrNull
  }

  ["restOrNull"] {
    list1.restOrNull
    List().restOrNull
  }

  ["lastOrNull"] {
    list1.lastOrNull
    List().lastOrNull
  }

  ["singleOrNull"] {
    List(1).singleOrNull
    list1.singleOrNull
    List().singleOrNull
  }

  ["findOrNull()"] {
    list1.findOrNull((x) -> x >= 2)
    list1.findOrNull((x) -> false)
    module.catch(() -> list1.findOrNull((x) -> "wrong type"))
  }

  ["findLastOrNull()"] {
    list1.findLastOrNull((x) -> x >= 2)
    list1.findLastOrNull((x) -> false)
    module.catch(() -> list1.findLastOrNull((x) -> "wrong type"))
  }

  ["indexOfOrNull()"] {
    list1.indexOfOrNull(2)
    list1.indexOfOrNull(4)
  }

  ["lastIndexOfOrNull()"] {
    list1.lastIndexOfOrNull(2)
    list1.lastIndexOfOrNull(4)
  }

  ["findIndexOrNull()"] {
    list1.findIndexOrNull((x) -> x >= 2)
    list1.findIndexOrNull((x) -> false)
    module.catch(() -> list1.findIndexOrNull((x) -> "wrong type"))
  }

  ["findLastIndexOrNull()"] {
    list1.findLastIndexOrNull((x) -> x >= 2)
    list1.findLastIndexOrNull((x) -> false)
    module.catch(() -> list1.findLastIndexOrNull((x) -> "wrong type"))
  }

  ["reduceOrNull()"] {
    list1.reduceOrNull((x, y) -> x + y)
    List(1).reduceOrNull((x, y) -> x + y)
    List().reduceOrNull((x, y) -> x + y)
  }

  ["replaceRangeOrNull()"] {
    local list2 = List(1, 2, 3, 4, 5)
    list2.replaceRangeOrNull(1, 4, List(9, 8))
    list2.replaceRangeOrNull(1, 4, List(9))
    list2.replaceRangeOrNull(1, 4, List())
    list2.replaceRangeOrNull(1, 1, List(9, 8))
    list2.replaceRangeOrNull(1, 1, List(9))
    list2.replaceRangeOrNull(1, 1, List())
    list2.replaceRangeOrNull(-1, 2, List(1))
    list2.replaceRangeOrNull(3, 6, List(1))
  }

  ["replaceOrNull()"] {
    list1.replaceOrNull(0, 42)
    list1.replaceOrNull(1, 42)
    list1.replaceOrNull(2, 42)

    list1.replaceOrNull(-1, 42)
    list1.replaceOrNull(3, 42)
    List().replaceOrNull(0, 42)
  }

  ["minWithOrNull()"] {
    local comparator = (x, y) -> x < y

    list1.minWithOrNull(comparator)
    List(1).minWithOrNull(comparator)
    List().minWithOrNull(comparator)

    list1.maxWithOrNull(comparator)
    List(1).maxWithOrNull(comparator)
    List().maxWithOrNull(comparator)
  }

  ["splitOrNull()"] {
    list1.splitOrNull(0)
    list1.splitOrNull(1)
    list1.splitOrNull(2)
    list1.splitOrNull(3)
    List().split(0)
    list1.splitOrNull(-1)
    list1.splitOrNull(4)
  }

  ["minOrNull"] {
    list1.minOrNull
    List("Pigeon", "Barn Owl", "Parrot").minOrNull
    List(3.9, -8.4, 42, -99999).minOrNull
    List(42, 42, 42).minOrNull
    List(42, 42.0).minOrNull
    List(42.0, 42).minOrNull
    List(11.gb, 100.mb, 12.tb).minOrNull
    List(11.s, 100.ms, 3.d).minOrNull
    List().minOrNull
    module.catch(() -> List(1, "Pigeon", 3.d).minOrNull)
  }

  ["maxOrNull"] {
    list1.maxOrNull
    List("Pigeon", "Barn Owl", "Parrot").maxOrNull
    List(3.9, -8.4, 42, -99999).maxOrNull
    List(42, 42, 42).maxOrNull
    List(42, 42.0).maxOrNull
    List(42.0, 42).maxOrNull
    List(11.gb, 100.mb, 12.tb).maxOrNull
    List(11.s, 100.ms, 3.d).maxOrNull
    List().maxOrNull
    module.catch(() -> List(1, "Pigeon", 3.d).maxOrNull)
  }

  ["minByOrNull()"] {
    list1.minByOrNull((it) -> it)
    list1.minByOrNull((it) -> -it)
    List("Pigeon", "Barn Owl", "Parrot").minByOrNull((it) -> it.length)
    List("Pigeon", "Barn Owl", "Parrot").minByOrNull((it) -> it.reverse())
    List(11.gb, 100.mb, 12.tb).minByOrNull((it) -> it.value)
    List(11.gb, 100.mb, 12.tb).minByOrNull((it) -> it)
    List(11.s, 100.ms, 12.min).minByOrNull((it) -> it.value)
    List(11.s, 100.ms, 12.min).minByOrNull((it) -> it)
    List().minByOrNull((it) -> it)
    module.catch(() -> List(1, "Pigeon", 3.d).minByOrNull((it) -> it))
  }

  ["maxByOrNull()"] {
    list1.maxByOrNull((it) -> it)
    list1.maxByOrNull((it) -> -it)
    List("Pigeon", "Barn Owl", "Parrot").maxByOrNull((it) -> it.length)
    List("Pigeon", "Barn Owl", "Parrot").maxByOrNull((it) -> it.reverse())
    List(11.gb, 100.mb, 12.tb).maxByOrNull((it) -> it.value)
    List(11.gb, 100.mb, 12.tb).maxByOrNull((it) -> it)
    List(11.s, 100.ms, 12.min).maxByOrNull((it) -> it.value)
    List(11.s, 100.ms, 12.min).maxByOrNull((it) -> it)
    List().maxByOrNull((it) -> it)
    module.catch(() -> List(1, "Pigeon", 3.d).maxByOrNull((it) -> it))
  }
}
