/* 	$OpenBSD: test_argv.c,v 1.4 2021/12/14 21:25:27 deraadt Exp $ */
/*
 * Regress test for misc argv handling functions.
 *
 * Placed in the public domain.
 */

#include "../test_helper/test_helper.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "log.h"
#include "misc.h"

void test_argv(void);

void
test_argv(void)
{
	char **av = NULL;
	int ac = 0;

#define RESET_ARGV() \
	do { \
		argv_free(av, ac); \
		av = NULL; \
		ac = -1; \
	} while (0)

	TEST_START("empty args");
	ASSERT_INT_EQ(argv_split("", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 0);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_PTR_EQ(av[0], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("    ", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 0);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_PTR_EQ(av[0], NULL);
	RESET_ARGV();
	TEST_DONE();

	TEST_START("trivial args");
	ASSERT_INT_EQ(argv_split("leamas", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "leamas");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("smiley leamas", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 2);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley");
	ASSERT_STRING_EQ(av[1], "leamas");
	ASSERT_PTR_EQ(av[2], NULL);
	RESET_ARGV();
	TEST_DONE();

	TEST_START("quoted");
	ASSERT_INT_EQ(argv_split("\"smiley\"", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("leamas \" smiley \"", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 2);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "leamas");
	ASSERT_STRING_EQ(av[1], " smiley ");
	ASSERT_PTR_EQ(av[2], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("\"smiley leamas\"", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley leamas");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("smiley\" leamas\" liz", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 2);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley leamas");
	ASSERT_STRING_EQ(av[1], "liz");
	ASSERT_PTR_EQ(av[2], NULL);
	RESET_ARGV();
	TEST_DONE();

	TEST_START("escaped");
	ASSERT_INT_EQ(argv_split("\\\"smiley\\'", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "\"smiley'");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("'\\'smiley\\\"'", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "'smiley\"");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("smiley\\'s leamas\\'", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 2);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley's");
	ASSERT_STRING_EQ(av[1], "leamas'");
	ASSERT_PTR_EQ(av[2], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("leamas\\\\smiley", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "leamas\\smiley");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("leamas\\\\ \\\\smiley", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 2);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "leamas\\");
	ASSERT_STRING_EQ(av[1], "\\smiley");
	ASSERT_PTR_EQ(av[2], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("smiley\\ leamas", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley leamas");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	TEST_DONE();

	TEST_START("quoted escaped");
	ASSERT_INT_EQ(argv_split("'smiley\\ leamas'", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley\\ leamas");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	ASSERT_INT_EQ(argv_split("\"smiley\\ leamas\"", &ac, &av), 0);
	ASSERT_INT_EQ(ac, 1);
	ASSERT_PTR_NE(av, NULL);
	ASSERT_STRING_EQ(av[0], "smiley\\ leamas");
	ASSERT_PTR_EQ(av[1], NULL);
	RESET_ARGV();
	TEST_DONE();

	/* XXX test char *argv_assemble(int argc, char **argv) */
}
