//
//  PXToolPropertiesController.m
//  Pixen-XCode
//
//  Created by Andy Matuschak on Fri Mar 12 2004.
//  Copyright (c) 2004 Open Sword Group. All rights reserved.
//

#import "PXToolPropertiesController.h"
#import "PXToolSwitcher.h"
#import "PXToolPropertiesView.h"
#import "PXTool.h";


@implementation PXToolPropertiesController

+ properties
{
    static id instance = nil;
    if(instance == nil) { instance = [[self alloc] init]; }
    return instance;
}

- (void)windowWillClose:notification
{
	[[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"PXToolPropertiesIsOpen"];
}

- (IBAction)showWindow:sender
{
	[[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"PXToolPropertiesIsOpen"];
	[super showWindow:sender];
}

- init
{
    [super initWithWindowNibName:@"PXToolProperties"];
	[self window];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(toolDidChange:) name:PXToolDidChangeNotificationName object:nil];
    [(NSPanel *)[self window] setBecomesKeyOnlyIfNeeded:YES];
	blankPropertiesView = [[PXToolPropertiesView alloc] init];
	[self setPropertiesView:blankPropertiesView];
	[[self window] setFrameAutosaveName:@"PXToolPropertiesFrame"];
    return self;
}

- (void)dealloc
{
	[blankPropertiesView release];
	[super dealloc];
}

- (void)toolDidChange:aNotification
{
	if ([[[aNotification userInfo] objectForKey:@"newTool"] propertiesView] == nil)
	{
		[self setPropertiesView:[[PXToolPropertiesView alloc] init]];
	}
	else
	{
		[self setPropertiesView:[[[aNotification userInfo] objectForKey:@"newTool"] propertiesView]];
	}
}

- (void)setPropertiesView:propertiesView
{
	NSRect newPropertiesFrame = [propertiesView frame];
	NSRect newViewFrame = NSMakeRect(0, 0, newPropertiesFrame.size.width, newPropertiesFrame.size.height);
	NSRect newWindowFrame = [[self window] frameRectForContentRect:NSMakeRect([[self window] frame].origin.x, [[self window] frame].origin.y, newPropertiesFrame.size.width, newPropertiesFrame.size.height)];
	[view setFrame:newViewFrame];
	[[self window] setFrame:newWindowFrame display:YES animate:YES];
	if ([[view subviews] count])
	{
		[[[view subviews] objectAtIndex:0] removeFromSuperviewWithoutNeedingDisplay];
	}
	[view addSubview:propertiesView];	
}

@end