//
//  PXPreviewResizeSizeView.m
//  Pixen-XCode
//
//  Created by Ian Henderson on Fri Jul 16 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import "PXPreviewResizeSizeView.h"


@implementation PXPreviewResizeSizeView

- initWithFrame:(NSRect)frame
{
	[super initWithFrame:frame];
	shadow = [[NSShadow alloc] init];
	[shadow setShadowBlurRadius:5];
	[shadow setShadowOffset:NSMakeSize(0, 0)];
	[shadow setShadowColor:[NSColor blackColor]];
	[self updateScale:0];
	return self;
}

- (void)updateScale:(float)scale
{
	if (scale > 100000) {
		return;
	}
	[scaleString release];
	scaleString = [[NSAttributedString alloc] initWithString:[NSString stringWithFormat:@"%d%%", (int)(scale * 100)] attributes:[NSDictionary dictionaryWithObjectsAndKeys:
		[NSFont fontWithName:@"Verdana" size:20], NSFontAttributeName,
		[NSColor whiteColor], NSForegroundColorAttributeName,
		shadow, NSShadowAttributeName,
		nil]];
	[self setNeedsDisplay:YES];
}

- (void)drawRect:(NSRect)rect
{
	[[NSColor clearColor] set];
	NSRectFill([self frame]);
	NSBezierPath *background = [NSBezierPath bezierPath];
	if ([self frame].size.height >= [self frame].size.width) {
		[background appendBezierPathWithOvalInRect:[self frame]];
	}
	else if ([self frame].size.height < [self frame].size.width) {
		NSRect leftSide = NSMakeRect([self frame].origin.x, [self frame].origin.y, [self frame].size.height, [self frame].size.height);
		NSRect rightSide = NSMakeRect([self frame].origin.x + [self frame].size.width - [self frame].size.height, [self frame].origin.y, [self frame].size.height, [self frame].size.height);
		NSRect middle = NSMakeRect([self frame].origin.x + ([self frame].size.height / 2.0f), [self frame].origin.y, [self frame].size.width - [self frame].size.height, [self frame].size.height);
		[background appendBezierPathWithOvalInRect:leftSide];
		[background appendBezierPathWithOvalInRect:rightSide];
		[background appendBezierPathWithRect:middle];
	}
	[[NSColor colorWithCalibratedRed:0 green:0 blue:0 alpha:.5] set];
	[background fill];
	NSPoint stringPoint = [self frame].origin;
	stringPoint.x += 10; // completely arbitrary, hard-coded numbers!  chyes!
	stringPoint.y += 3;
	[scaleString drawAtPoint:stringPoint];
}

- (NSSize)scaleStringSize
{
	NSSize size = [scaleString size];
	return NSMakeSize(size.width + 20, size.height);
}

@end
