#import "PXPaletteSwitcher.h"
#import "PXPalette.h"
#import "PXNamePrompter.h"
#import "PXCanvas.h"
#import "MyDocument.h"
#import "PXColorPaletteController.h"

@implementation PXPaletteSwitcher

+ defaultPalettes
{
    static id palettes = nil;
    if(palettes == nil) 
	{ 
		id list = [NSColorList colorListNamed:@"Crayons"];
		id defaultColors = [NSMutableArray arrayWithCapacity:12];
		id enumerator = [[list allKeys] objectEnumerator];
		id current;
		while(current = [enumerator nextObject])
		{
			[defaultColors addObject:[list colorWithKey:current]];
		}
		palettes = [[NSArray alloc] initWithObjects:
			[[[PXPalette alloc] initWithName:@"Crayons" colors:defaultColors] autorelease], 
			nil]; 
	}
    return palettes;
}

- init
{
	[super init];
    namePrompter = [[PXNamePrompter alloc] init];
    [namePrompter setDelegate:self];
	defaultPalettes = [[NSMutableArray alloc] initWithCapacity:32];
	userPalettes = [[NSMutableArray alloc] initWithCapacity:32];
    return self;
}

- (void)populatePopup:aPopup withDefaultPalettesUsingSelectionAction:(SEL)aSelector
{
	if([defaultPalettes count] == 0)
	{
		defaultPalettes = [[[self class] defaultPalettes] copy];
	}
	id enumerator = [defaultPalettes objectEnumerator];
    id current;
    while(current = [enumerator nextObject])
    {
        id item = [[[NSMenuItem alloc] initWithTitle:[current name] action:aSelector keyEquivalent:@""] autorelease];
        [item setRepresentedObject:[[current copy] autorelease]];
		[item setTarget:self];
        [[aPopup menu] addItem:item];
    }
}

- (void)populatePopup:aPopup withUserPalettesUsingSelectionAction:(SEL)aSelector
{
	if([userPalettes count] == 0)
	{
		id enumerator = [[NSFileManager defaultManager] enumeratorAtPath:[@"~/Library/Application Support/Pixen/Palettes/Presets" stringByExpandingTildeInPath]];
		id current;
		while(current = [enumerator nextObject])
		{
			if([[current pathExtension] isEqualToString:@"pxpalette"])
			{
				id aPalette = [NSKeyedUnarchiver unarchiveObjectWithFile:[[@"~/Library/Application Support/Pixen/Palettes/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:current]];
				id item = [[[NSMenuItem alloc] initWithTitle:[current stringByDeletingPathExtension] action:aSelector keyEquivalent:@""] autorelease];
				[item setRepresentedObject:aPalette];
				[item setTarget:self];
				[[aPopup menu] addItem:item];
				[userPalettes addObject:aPalette];
			}
		}
	}
	else
	{
		id enumerator = [userPalettes objectEnumerator];
		id current;
		while(current = [enumerator nextObject])
		{
			id item = [[[NSMenuItem alloc] initWithTitle:[current name] action:aSelector keyEquivalent:@""] autorelease];
			[item setRepresentedObject:current];
			[item setTarget:self];
			[[aPopup menu] addItem:item];
		}
	}
}

- (void)populateMenuForCanvas:aCanvas
{
	canvas = aCanvas;
    id selected = [[[paletteChooser titleOfSelectedItem] retain] autorelease];
    [paletteChooser removeAllItems];
    id menu = [paletteChooser menu];
    [self populatePopup:paletteChooser withDefaultPalettesUsingSelectionAction:@selector(selectPalette:)];
    [menu addItem:[NSMenuItem separatorItem]];
    [self populatePopup:paletteChooser withUserPalettesUsingSelectionAction:@selector(selectPalette:)];
    [menu addItem:[NSMenuItem separatorItem]];
	id canvasPalette = [canvas palette];    
	if(canvasPalette != nil)
	{
		id item = [[[NSMenuItem alloc] initWithTitle:[canvasPalette name] action:@selector(selectPalette:) keyEquivalent:@""] autorelease];
		[item setRepresentedObject:canvasPalette];
		[item setTarget:self];
		[[paletteChooser menu] addItem:item];
		[menu addItem:[NSMenuItem separatorItem]];
	}
	[menu addItemWithTitle:@"Save as new palette..." action:@selector(saveCurrentPalette:) keyEquivalent:@""];
	[[menu itemWithTitle:@"Save as new palette..."] setTarget:self];
    [menu addItemWithTitle:@"Delete current palette" action:@selector(deleteCurrentPalette:) keyEquivalent:@""];
	[[menu itemWithTitle:@"Delete current palette"] setTarget:self];
    if(![[paletteChooser itemTitles] containsObject:selected] || [[paletteChooser titleOfSelectedItem] isEqualToString:@"Delete current palette"] || (selected == nil) || [selected isEqual:@""]) 
	{ 
		[self selectPaletteNamed:@"Default"];
		[self performSelector:[[paletteChooser selectedItem] action] withObject:[paletteChooser selectedItem]]; 
	}
	else if(![selected isEqualToString:@"Save as new palette..."])
	{
		[paletteChooser selectItemWithTitle:selected];
		[self performSelector:[[paletteChooser selectedItem] action] withObject:[paletteChooser selectedItem]]; 
	}
}

- (IBAction)saveCurrentPalette:sender
{
    [namePrompter promptInWindow:[delegate window] context:palette promptString:@"Please name the new palette." defaultEntry:[palette name]];
}

- (void)createApplicationSupportSubdirectories
{
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen" stringByExpandingTildeInPath] attributes:nil];
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen/Palettes" stringByExpandingTildeInPath] attributes:nil];
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen/Palettes/Presets" stringByExpandingTildeInPath] attributes:nil];
}

- (void)prompter:aPrompter didFinishWithName:name context:contextObject
{
    id newPalette = [[contextObject copy] autorelease];
    [(PXPalette *)newPalette setName:name];
    [self createApplicationSupportSubdirectories];
    [NSKeyedArchiver archiveRootObject:newPalette toFile:[[[@"~/Library/Application Support/Pixen/Palettes/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:name] stringByAppendingPathExtension:@"pxpalette"]];
	if(![[[newPalette name] lowercaseString] isEqual:[[contextObject name] lowercaseString]])
	{
		[userPalettes addObject:newPalette];
	}
	else
	{
		[userPalettes replaceObjectAtIndex:[userPalettes indexOfObject:contextObject] withObject:newPalette];
	}
    [self populateMenuForCanvas:canvas];
    [paletteChooser selectItemWithTitle:name];
    [self performSelector:[[paletteChooser itemWithTitle:name] action] withObject:[paletteChooser itemWithTitle:name]];
}

- (void)prompter:aPrompter didCancelWithContext:contextObject
{
    [paletteChooser selectItemWithTitle:[palette name]];
    [self performSelector:[[paletteChooser itemWithTitle:[palette name]] action] withObject:[paletteChooser itemWithTitle:[palette name]]];
}

- (IBAction)deleteCurrentPalette:sender
{
    id path = [[[@"~/Library/Application Support/Pixen/Palettes/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:[palette name]] stringByAppendingPathExtension:@"pxpalette"];
    if(![[NSFileManager defaultManager] fileExistsAtPath:path]) { return; }
    [[NSFileManager defaultManager] removeFileAtPath:path handler:nil];
	[userPalettes removeObject:palette];
    [self populateMenuForCanvas:canvas];
}

- (void)dealloc
{
	[userPalettes release];
	[defaultPalettes release];
	[namePrompter release];
    [super dealloc];
}

- (IBAction)selectPalette:sender
{
	palette = [sender representedObject];
	[delegate setPalette:palette];
}

- (void)selectPaletteNamed:aName
{
	if([aName isEqual:@"Default"] && ([paletteChooser itemWithTitle:@"Default"] == nil))
	{
		[paletteChooser selectItemAtIndex:0];
	}
	else
	{
		if([paletteChooser itemWithTitle:aName] == nil) { return; }
		[paletteChooser selectItemWithTitle:aName];
	}
    [self performSelector:[[paletteChooser selectedItem] action] withObject:[paletteChooser selectedItem]];
}

- (void)setDelegate:aDelegate
{
    delegate = aDelegate;
}

@end
