/* PXPaletteSwitcher */

#import <Cocoa/Cocoa.h>

@interface PXPaletteSwitcher : NSObject
{
    IBOutlet id delegate;
    IBOutlet id paletteChooser;
	id userPalettes, defaultPalettes;
	id palette;
	id namePrompter;
	id canvas;
}

+ defaultPalettes;
- init;
- (void)populatePopup:aPopup withDefaultPalettesUsingSelectionAction:(SEL)aSelector;
- (void)populatePopup:aPopup withUserPalettesUsingSelectionAction:(SEL)aSelector;
- (void)populateMenuForCanvas:canvas;
- (IBAction)saveCurrentPalette:sender;
- (void)createApplicationSupportSubdirectories;
- (void)prompter:aPrompter didFinishWithName:name context:contextObject;
- (void)prompter:aPrompter didCancelWithContext:contextObject;
- (IBAction)deleteCurrentPalette:sender;
- (void)dealloc;
- (IBAction)selectPalette:sender;
- (void)setDelegate:aDelegate;
- (void)selectPaletteNamed:aName;

@end
