//
//  PXNamePrompter.m
//  Pixel Editor
//
//  Created by Open Sword Group on Thu May 01 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import "PXNamePrompter.h"
#import "PXCanvasView.h"

@implementation PXNamePrompter

- init
{
    return [super initWithWindowNibName:@"PXNamePrompt"];
}

- (void)setDelegate:newDelegate
{
    delegate = newDelegate;
}

- (void)promptInWindow:window context:contextInfo
{
	[self promptInWindow:window context:contextInfo promptString:@"Please name the new configuration." defaultEntry:@""];
}

- (void)promptInWindow:window context:contextInfo promptString:string defaultEntry:entry
{
    context = contextInfo;
    [NSApp beginSheet:[self window] modalForWindow:window modalDelegate:nil didEndSelector:NULL contextInfo:NULL];
	[nameField setStringValue:entry];
}

- (IBAction)useEnteredName:sender
{
    if([[nameField stringValue] isEqualToString:@""]) { return; }
    if([delegate respondsToSelector:@selector(prompter:didFinishWithName:context:)]) { [delegate prompter:self didFinishWithName:[nameField stringValue] context:context]; }
    [NSApp endSheet:[self window]];
    [self close];
}

- (IBAction)cancel:sender
{
    [NSApp endSheet:[self window]];
    [self close];
    if([delegate respondsToSelector:@selector(prompter:didCancelWithContext:)]) { [delegate prompter:self didCancelWithContext:context]; }
}

@end
