//
//  PXBackgroundController.m
//  Pixen-XCode
//
//  Created by Joe Osborn on Sun Oct 26 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import "PXBackgroundController.h"
#import "PXSlashyBackground.h"
#import "PXMonotoneBackground.h"
#import "PXCheckeredBackground.h"
#import "PXImageBackground.h"
#import "PXBackground.h"
#import "PXNamePrompter.h"
#import "PXCanvas.h"

@implementation PXBackgroundController

+ backgroundNamed:aName
{
    id enumerator = [[self defaultBackgrounds] objectEnumerator];
    id current;
    while(current = [enumerator nextObject])
    {
        if([[current name] isEqualToString:aName])
        {
            return [[current copy] autorelease];
        }
    }
    enumerator = [[NSFileManager defaultManager] enumeratorAtPath:[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath]];
    while(current = [enumerator nextObject])
    {
        if((![current isEqualToString:@".DS_Store"]) && [[current stringByDeletingPathExtension] isEqualToString:aName])
        {
            return [NSKeyedUnarchiver unarchiveObjectWithFile:[[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:current]];
        }
    }
    NSLog(@"Background named %@ not found.", aName);
    return [[[[self defaultBackgrounds] objectAtIndex:0] copy] autorelease];
}

+ defaultBackgrounds
{
    static id backgrounds = nil;
    if(backgrounds == nil) { backgrounds = [[NSArray alloc] initWithObjects:[[[PXSlashyBackground alloc] init] autorelease], [[[PXMonotoneBackground alloc] init] autorelease], [[[PXCheckeredBackground alloc] init] autorelease], [[[PXImageBackground alloc] init] autorelease], nil]; }
    return backgrounds;
}

- init
{
    [self initWithWindowNibName:@"PXBackgroundController"];
    usesAlternateBackground = YES;
    namePrompter = [[PXNamePrompter alloc] init];
    [namePrompter setDelegate:self];
    return self;
}

- (void)populatePopup:aPopup withDefaultBackgroundsUsingSelectionAction:(SEL)aSelector
{
    id enumerator = [[[self class] defaultBackgrounds] objectEnumerator];
    id current;
    while(current = [enumerator nextObject])
    {
        id item = [[[NSMenuItem alloc] initWithTitle:[current name] action:aSelector keyEquivalent:@""] autorelease];
        [item setRepresentedObject:[[current copy] autorelease]];
        [[aPopup menu] addItem:item];
    }   
}

- (void)populatePopup:aPopup withUserBackgroundsUsingSelectionAction:(SEL)aSelector
{
    id enumerator = [[NSFileManager defaultManager] enumeratorAtPath:[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath]];
    id current;
    while(current = [enumerator nextObject])
    {
        if([[current pathExtension] isEqualToString:@"pxbgnd"])
        {
            id item = [[[NSMenuItem alloc] initWithTitle:[current stringByDeletingPathExtension] action:aSelector keyEquivalent:@""] autorelease];
            [item setRepresentedObject:[NSKeyedUnarchiver unarchiveObjectWithFile:[[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:current]]];
            [[aPopup menu] addItem:item];
        }
    }
}

- (void)populateMenu:aPopup selectionAction:(SEL)aSelector
{
    id selected = [[[aPopup titleOfSelectedItem] retain] autorelease];
    [aPopup removeAllItems];
    id menu = [aPopup menu];
    [self populatePopup:aPopup withDefaultBackgroundsUsingSelectionAction:aSelector];
    [menu addItem:[NSMenuItem separatorItem]];
    [self populatePopup:aPopup withUserBackgroundsUsingSelectionAction:aSelector];
    [menu addItem:[NSMenuItem separatorItem]];
    [menu addItemWithTitle:@"Save as new configuration..." action:@selector(saveCurrentConfiguration:) keyEquivalent:@""];
    [menu addItemWithTitle:@"Delete current configuration" action:@selector(deleteCurrentConfiguration:) keyEquivalent:@""];
    if(![[aPopup itemTitles] containsObject:selected] || [[aPopup titleOfSelectedItem] isEqualToString:@"Delete current configuration"]) { [aPopup selectItemAtIndex:0]; }
    else { [aPopup selectItemWithTitle:selected]; }
	//    if([self respondsToSelector:[[aPopup selectedItem] action]]) { [self performSelector:[[aPopup selectedItem] action] withObject:[aPopup selectedItem]]; }
}

- (void)populateMenus
{
    [self populateMenu:mainMenu selectionAction:@selector(selectMainBackground:)];
    [self populateMenu:alternateMenu selectionAction:@selector(selectAlternateBackground:)];
}

- (IBAction)saveCurrentConfiguration:sender
{
    id context;
    id menu;
    if([[mainMenu titleOfSelectedItem] isEqualToString:@"Save as new configuration..."])
    {
        context = mainBackground;
        menu = mainMenu;
    }
    else if([[alternateMenu titleOfSelectedItem] isEqualToString:@"Save as new configuration..."])
    {
        context = alternateBackground;   
        menu = alternateMenu;
    }
    [namePrompter promptInWindow:[self window] context:context];
}

- (void)createApplicationSupportSubdirectories
{
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen" stringByExpandingTildeInPath] attributes:nil];
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen/Backgrounds" stringByExpandingTildeInPath] attributes:nil];
    [[NSFileManager defaultManager] createDirectoryAtPath:[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath] attributes:nil];
}

- (void)prompter:aPrompter didFinishWithName:name context:contextObject
{
    PXBackground * newConfig = [[contextObject copy] autorelease];
    id menu;
    if(contextObject == mainBackground)
    {
        menu = mainMenu;
    }
    else if(contextObject == alternateBackground)
    {
        menu = alternateMenu;
    }
    [newConfig setName:name];
    [self createApplicationSupportSubdirectories];
    [NSKeyedArchiver archiveRootObject:newConfig toFile:[[[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:name] stringByAppendingPathExtension:@"pxbgnd"]];
    [self populateMenus];
    [menu selectItemWithTitle:name];
    [self performSelector:[[menu itemWithTitle:name] action] withObject:[menu itemWithTitle:name]];
}

- (void)prompter:aPrompter didCancelWithContext:contextObject
{
    id config = contextObject;
    id menu;
    if(config == mainBackground)
    {
        menu = mainMenu;
    }
    else if(config == alternateBackground)
    {
        menu = alternateMenu;
    }
    [menu selectItemWithTitle:[config name]];
}

- (IBAction)deleteCurrentConfiguration:sender
{
    id config;
    id menu;
    if([[mainMenu titleOfSelectedItem] isEqualToString:@"Delete current configuration"])
    {
        menu = mainMenu;
        config = mainBackground;
        [self setMainBackground:[[[self class] defaultBackgrounds] objectAtIndex:0]];
    }
    else if([[alternateMenu titleOfSelectedItem] isEqualToString:@"Delete current configuration"])
    {
        config = alternateBackground;
        menu = alternateMenu;
        [self setAlternateBackground:[[[self class] defaultBackgrounds] objectAtIndex:1]];
    }
    if(![config isKindOfClass:[PXBackground class]]) { [menu selectItemAtIndex:0]; return; }
    id path = [[[@"~/Library/Application Support/Pixen/Backgrounds/Presets" stringByExpandingTildeInPath] stringByAppendingPathComponent:[config name]] stringByAppendingPathExtension:@"pxbgnd"];
    if(![[NSFileManager defaultManager] fileExistsAtPath:path]) { NSBeep(); [menu selectItemAtIndex:0]; return; }
    [[NSFileManager defaultManager] removeFileAtPath:path handler:nil];
    [self populateMenus];
}

- (void)awakeFromNib
{
    [self populateMenus];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(backgroundChanged:) name:@"PXBackgroundChanged" object:nil];
}

- (void)windowDidLoad
{
    [mainConfigurator addSubview:[mainBackground configurator]];
    [alternateConfigurator addSubview:[alternateBackground configurator]];
}

- (void)dealloc
{
    [mainBackground release];
    [alternateBackground release];
    [super dealloc];
}

- (void)setUsesAlternateBackground:(BOOL)newUsesAlternateBackground
{
	usesAlternateBackground = newUsesAlternateBackground;
    [alternateMenu setEnabled:usesAlternateBackground];
    [alternateBackground setConfiguratorEnabled:usesAlternateBackground];
    [delegate setAlternateBackground:(usesAlternateBackground ? alternateBackground : nil)];	
	[alternateCheckbox setState:usesAlternateBackground];
}

- (IBAction)useAlternateBackgroundCheckboxClicked:sender
{
	[self setUsesAlternateBackground:([sender state] == NSOnState)];
}

- (IBAction)selectMainBackground:sender
{
    [self setMainBackground:[sender representedObject]];
}

- (IBAction)selectAlternateBackground:sender
{
    [self setAlternateBackground:[sender representedObject]];
}

- (void)setDelegate:aDelegate
{
    delegate = aDelegate;
}

#define PXBackgroundControllerSetBackground(bg, menu, configView, newBg)\
{\
    [[bg configurator] removeFromSuperview];\
        [newBg retain];\
            [bg release];\
                bg = newBg;\
                    [menu selectItemWithTitle:[bg name]];\
                        [configView addSubview:[bg configurator]];\
}

- (void)setMainBackground:aBackground
{
    PXBackgroundControllerSetBackground(mainBackground, mainMenu, mainConfigurator, aBackground);
    [delegate setMainBackground:mainBackground];
}

- (void)setAlternateBackground:aBackground
{
    PXBackgroundControllerSetBackground(alternateBackground, alternateMenu, alternateConfigurator, aBackground);
    [delegate setAlternateBackground:alternateBackground];
}

- (void)backgroundChanged:notification
{
    [delegate backgroundChanged:notification];
}

- (void)setDefaultBackgroundsFor:aCanvas
{
	id defaults = [NSUserDefaults standardUserDefaults];
	id mainBackgroundName = [defaults objectForKey:@"mainBackgroundName"];
	id alternateBackgroundName = [defaults objectForKey:@"alternateBackgroundName"];
	if(mainBackgroundName == nil) { mainBackgroundName = @"Slashed Background"; }
	if(alternateBackgroundName == nil) { alternateBackgroundName = @"Flat Background"; }
	[aCanvas setMainBackgroundName:mainBackgroundName];
	[aCanvas setAlternateBackgroundName:alternateBackgroundName];
	[self setMainBackground:[[self class] backgroundNamed:mainBackgroundName]];
	[self setAlternateBackground:[[self class] backgroundNamed:alternateBackgroundName]];
	[self setUsesAlternateBackground:[defaults boolForKey:@"usesAlternateBackground"]];	
}

- (void)useBackgroundsOf:aCanvas
{
    [self window];
	if([aCanvas mainBackgroundName] == nil) 
	{ 
		[self setDefaultBackgroundsFor:aCanvas];
		return;
	}
	NSString * mainName = [[aCanvas mainBackgroundName] retain], * altName = [[aCanvas alternateBackgroundName] retain];
	[self setMainBackground:[[self class] backgroundNamed:mainName]];
	if((altName == nil) || [altName isEqualToString:mainName])
	{
		[self setAlternateBackground:nil];
		[self setUsesAlternateBackground:NO];
	}
	else
	{
		[self setAlternateBackground:[[self class] backgroundNamed:altName]];
		[self setUsesAlternateBackground:YES];
	}
	[mainName release];
	[altName release];
}

- (IBAction)useCurrentBackgroundsAsDefaults:sender
{
    id defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:[mainBackground name] forKey:@"mainBackgroundName"];
    [defaults setObject:[alternateBackground name] forKey:@"alternateBackgroundName"];
	[defaults setBool:usesAlternateBackground forKey:@"usesAlternateBackground"];
    [defaults synchronize];
}

@end
